/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.integration.guicepersist.standalone;

import com.google.inject.persist.Transactional;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.codejargon.fluentjdbc.api.integration.guicepersist.standalone.StandaloneTxConnectionProvider;

class TransactionInterceptor
implements MethodInterceptor {
    private final StandaloneTxConnectionProvider standaloneTxConnectionProvider;

    TransactionInterceptor(StandaloneTxConnectionProvider standaloneTxConnectionProvider) {
        this.standaloneTxConnectionProvider = standaloneTxConnectionProvider;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Boolean newTransactionStarted = this.startNewTransactionIfNecessary();
        try {
            Object result = methodInvocation.proceed();
            if (newTransactionStarted.booleanValue()) {
                this.standaloneTxConnectionProvider.commitActiveTransaction(Optional.empty());
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            this.rollbackOrCommit(methodInvocation, e);
            throw e;
        }
        finally {
            if (newTransactionStarted.booleanValue()) {
                this.standaloneTxConnectionProvider.removeActiveTransactionConnection();
            }
        }
    }

    private Boolean startNewTransactionIfNecessary() {
        if (!this.standaloneTxConnectionProvider.hasActiveTransaction().booleanValue()) {
            this.standaloneTxConnectionProvider.startNewTransaction();
            return true;
        }
        return false;
    }

    private void rollbackOrCommit(MethodInvocation methodInvocation, Exception e) {
        if (this.rollbackNecessary(e, this.transactional(methodInvocation))) {
            this.standaloneTxConnectionProvider.rollbackActiveTransaction();
        } else {
            this.standaloneTxConnectionProvider.commitActiveTransaction(Optional.of(e));
        }
    }

    private Transactional transactional(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Class<?> targetClass = methodInvocation.getThis().getClass();
        Transactional transactional = method.getAnnotation(Transactional.class);
        if (null == transactional) {
            transactional = targetClass.getAnnotation(Transactional.class);
        }
        if (null == transactional) {
            transactional = DefaultTransactionalDummy.class.getAnnotation(Transactional.class);
        }
        return transactional;
    }

    private boolean rollbackNecessary(Exception cause, Transactional transactional) {
        return !this.has(transactional.rollbackOn(), cause).isEmpty() && this.has(transactional.ignore(), cause).isEmpty();
    }

    private List<Class<? extends Exception>> has(Class<? extends Exception>[] exceptions, Exception cause) {
        return Arrays.asList(exceptions).stream().filter(e -> e.isInstance(cause)).collect(Collectors.toList());
    }

    @Transactional
    private static class DefaultTransactionalDummy {
        private DefaultTransactionalDummy() {
        }
    }
}

