/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.integration.guicepersist.standalone;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matchers;
import com.google.inject.persist.Transactional;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.codejargon.fluentjdbc.api.FluentJdbc;
import org.codejargon.fluentjdbc.api.FluentJdbcBuilder;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.integration.guicepersist.standalone.StandaloneTxConnectionProvider;
import org.codejargon.fluentjdbc.api.integration.guicepersist.standalone.TransactionInterceptor;
import org.codejargon.fluentjdbc.api.query.Query;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

public class StandaloneFluentJdbcModule
extends AbstractModule {
    private final DataSource dataSource;
    private final FluentJdbcBuilder fluentJdbcBuilder;

    public StandaloneFluentJdbcModule(FluentJdbcBuilder fluentJdbcBuilder, DataSource dataSource) {
        Preconditions.checkNotNull((Object)fluentJdbcBuilder, (String)"fluentJdbcBuilder");
        Preconditions.checkNotNull((Object)fluentJdbcBuilder, (String)"dataSource");
        this.fluentJdbcBuilder = fluentJdbcBuilder;
        this.dataSource = dataSource;
    }

    protected void configure() {
        StandaloneTxConnectionProvider cp = new StandaloneTxConnectionProvider(this.dataSource);
        FluentJdbc fluentJdbc = this.fluentJdbcBuilder.connectionProvider((ConnectionProvider)cp).build();
        this.bindFluentJdbc(fluentJdbc);
        this.bindTransactionInterceptors(cp);
    }

    private void bindFluentJdbc(FluentJdbc fluentJdbc) {
        this.bind(FluentJdbc.class).toInstance((Object)fluentJdbc);
        this.bind(Query.class).toInstance((Object)fluentJdbc.query());
    }

    private void bindTransactionInterceptors(StandaloneTxConnectionProvider cp) {
        TransactionInterceptor interceptor = new TransactionInterceptor(cp);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{interceptor});
        this.bindInterceptor(Matchers.annotatedWith(Transactional.class), Matchers.any(), new MethodInterceptor[]{interceptor});
    }
}

