/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.dom;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.ri.typed.SimpleValueEncoder;
import org.codehaus.stax2.typed.Base64Variant;
import org.codehaus.stax2.typed.Base64Variants;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DOMWrappingWriter
implements XMLStreamWriter2 {
    static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";
    static final String DEFAULT_XML_VERSION = "1.0";
    protected final boolean mNsAware;
    protected final boolean mNsRepairing;
    protected String mEncoding = null;
    protected NamespaceContext mNsContext;
    protected final Document mDocument;
    protected SimpleValueEncoder mValueEncoder;

    protected DOMWrappingWriter(Node treeRoot, boolean nsAware, boolean nsRepairing) throws XMLStreamException {
        if (treeRoot == null) {
            throw new IllegalArgumentException("Can not pass null Node for constructing a DOM-based XMLStreamWriter");
        }
        this.mNsAware = nsAware;
        this.mNsRepairing = nsRepairing;
        switch (treeRoot.getNodeType()) {
            case 9: {
                this.mDocument = (Document)treeRoot;
                break;
            }
            case 1: {
                this.mDocument = treeRoot.getOwnerDocument();
                break;
            }
            case 11: {
                this.mDocument = treeRoot.getOwnerDocument();
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamWriter for a DOM node of type " + treeRoot.getClass());
            }
        }
        if (this.mDocument == null) {
            throw new XMLStreamException("Can not create an XMLStreamWriter for given node (of type " + treeRoot.getClass() + "): did not have owner document");
        }
    }

    public void close() {
    }

    public void flush() {
    }

    public void setNamespaceContext(NamespaceContext context) {
        this.mNsContext = context;
    }

    public void writeCData(String data) {
        this.appendLeaf(this.mDocument.createCDATASection(data));
    }

    public void writeCharacters(char[] text, int start, int len) {
        this.writeCharacters(new String(text, start, len));
    }

    public void writeCharacters(String text) {
        this.appendLeaf(this.mDocument.createTextNode(text));
    }

    public void writeComment(String data) {
        this.appendLeaf(this.mDocument.createCDATASection(data));
    }

    public void writeDTD(String dtd) {
        this.reportUnsupported("writeDTD()");
    }

    public void writeProcessingInstruction(String target) {
        this.writeProcessingInstruction(target, null);
    }

    public void writeProcessingInstruction(String target, String data) {
        this.appendLeaf(this.mDocument.createProcessingInstruction(target, data));
    }

    public void writeStartDocument() {
        this.writeStartDocument(DEFAULT_OUTPUT_ENCODING, DEFAULT_XML_VERSION);
    }

    public void writeStartDocument(String version) {
        this.writeStartDocument(null, version);
    }

    public void writeStartDocument(String encoding, String version) {
        this.mEncoding = encoding;
    }

    public XMLStreamLocation2 getLocation() {
        return null;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    public void writeCData(char[] text, int start, int len) throws XMLStreamException {
        this.writeCData(new String(text, start, len));
    }

    public void writeFullEndElement() throws XMLStreamException {
        this.writeEndElement();
    }

    public void writeSpace(char[] text, int start, int len) {
        this.writeSpace(new String(text, start, len));
    }

    public void writeSpace(String text) {
        this.writeCharacters(text);
    }

    public void writeStartDocument(String version, String encoding, boolean standAlone) throws XMLStreamException {
        this.writeStartDocument(encoding, version);
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h) {
        return null;
    }

    public void writeRaw(String text) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    public void writeRaw(String text, int start, int offset) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    public void writeRaw(char[] text, int offset, int length) throws XMLStreamException {
        this.reportUnsupported("writeRaw()");
    }

    public void copyEventFromReader(XMLStreamReader2 r, boolean preserveEventData) throws XMLStreamException {
    }

    public void closeCompletely() {
    }

    public void writeBoolean(boolean value) throws XMLStreamException {
        this.writeCharacters(value ? "true" : "false");
    }

    public void writeInt(int value) throws XMLStreamException {
        this.writeCharacters(String.valueOf(value));
    }

    public void writeLong(long value) throws XMLStreamException {
        this.writeCharacters(String.valueOf(value));
    }

    public void writeFloat(float value) throws XMLStreamException {
        this.writeCharacters(String.valueOf(value));
    }

    public void writeDouble(double value) throws XMLStreamException {
        this.writeCharacters(String.valueOf(value));
    }

    public void writeInteger(BigInteger value) throws XMLStreamException {
        this.writeCharacters(value.toString());
    }

    public void writeDecimal(BigDecimal value) throws XMLStreamException {
        this.writeCharacters(value.toString());
    }

    public void writeQName(QName name) throws XMLStreamException {
        this.writeCharacters(this.serializeQNameValue(name));
    }

    public void writeIntArray(int[] value, int from, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(value, from, length));
    }

    public void writeLongArray(long[] value, int from, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(value, from, length));
    }

    public void writeFloatArray(float[] value, int from, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(value, from, length));
    }

    public void writeDoubleArray(double[] value, int from, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(value, from, length));
    }

    public void writeBinary(byte[] value, int from, int length) throws XMLStreamException {
        this.writeBinary(Base64Variants.getDefaultVariant(), value, from, length);
    }

    public void writeBinary(Base64Variant v, byte[] value, int from, int length) throws XMLStreamException {
        this.writeCharacters(this.getValueEncoder().encodeAsString(v, value, from, length));
    }

    public void writeBooleanAttribute(String prefix, String nsURI, String localName, boolean value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, value ? "true" : "false");
    }

    public void writeIntAttribute(String prefix, String nsURI, String localName, int value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, String.valueOf(value));
    }

    public void writeLongAttribute(String prefix, String nsURI, String localName, long value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, String.valueOf(value));
    }

    public void writeFloatAttribute(String prefix, String nsURI, String localName, float value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, String.valueOf(value));
    }

    public void writeDoubleAttribute(String prefix, String nsURI, String localName, double value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, String.valueOf(value));
    }

    public void writeIntegerAttribute(String prefix, String nsURI, String localName, BigInteger value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, value.toString());
    }

    public void writeDecimalAttribute(String prefix, String nsURI, String localName, BigDecimal value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, value.toString());
    }

    public void writeQNameAttribute(String prefix, String nsURI, String localName, QName name) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.serializeQNameValue(name));
    }

    public void writeIntArrayAttribute(String prefix, String nsURI, String localName, int[] value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(value, 0, value.length));
    }

    public void writeLongArrayAttribute(String prefix, String nsURI, String localName, long[] value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(value, 0, value.length));
    }

    public void writeFloatArrayAttribute(String prefix, String nsURI, String localName, float[] value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(value, 0, value.length));
    }

    public void writeDoubleArrayAttribute(String prefix, String nsURI, String localName, double[] value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(value, 0, value.length));
    }

    public void writeBinaryAttribute(String prefix, String nsURI, String localName, byte[] value) throws XMLStreamException {
        this.writeBinaryAttribute(Base64Variants.getDefaultVariant(), prefix, nsURI, localName, value);
    }

    public void writeBinaryAttribute(Base64Variant v, String prefix, String nsURI, String localName, byte[] value) throws XMLStreamException {
        this.writeAttribute(prefix, nsURI, localName, this.getValueEncoder().encodeAsString(v, value, 0, value.length));
    }

    protected abstract void appendLeaf(Node var1) throws IllegalStateException;

    protected String serializeQNameValue(QName name) throws XMLStreamException {
        String prefix;
        if (this.mNsRepairing) {
            String uri = name.getNamespaceURI();
            NamespaceContext ctxt = this.getNamespaceContext();
            String string = prefix = ctxt == null ? null : ctxt.getPrefix(uri);
            if (prefix == null) {
                String origPrefix = name.getPrefix();
                if (origPrefix == null || origPrefix.length() == 0) {
                    prefix = "";
                    this.writeDefaultNamespace(uri);
                } else {
                    prefix = origPrefix;
                    this.writeNamespace(prefix, uri);
                }
            }
        } else {
            prefix = name.getPrefix();
        }
        String local = name.getLocalPart();
        if (prefix == null || prefix.length() == 0) {
            return local;
        }
        return prefix + ":" + local;
    }

    protected SimpleValueEncoder getValueEncoder() {
        if (this.mValueEncoder == null) {
            this.mValueEncoder = new SimpleValueEncoder();
        }
        return this.mValueEncoder;
    }

    protected static void throwOutputError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg);
    }

    protected static void throwOutputError(String format, Object arg) throws XMLStreamException {
        String msg = MessageFormat.format(format, arg);
        DOMWrappingWriter.throwOutputError(msg);
    }

    protected void reportUnsupported(String operName) {
        throw new UnsupportedOperationException(operName + " can not be used with DOM-backed writer");
    }
}

