/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.waffle.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.codehaus.waffle.action.ActionMethodInvocationException;
import org.codehaus.waffle.controller.ScriptedController;
import org.jruby.Ruby;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyController
implements ScriptedController {
    private String methodName;
    private final IRubyObject rubyObject;

    public RubyController(IRubyObject rubyObject) {
        this.rubyObject = rubyObject;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public IRubyObject getScriptObject() {
        return this.rubyObject;
    }

    public Object execute() {
        Ruby runtime = this.rubyObject.getRuntime();
        String[] strings = this.methodName.split("\\|");
        try {
            IRubyObject result = this.callMethod(runtime, strings);
            return JavaUtil.convertRubyToJava((IRubyObject)result);
        }
        catch (RaiseException e) {
            throw new ActionMethodInvocationException(e.getException().message.toString());
        }
    }

    private IRubyObject callMethod(Ruby runtime, String[] strings) {
        IRubyObject result;
        if (strings.length == 1) {
            result = this.rubyObject.callMethod(runtime.getCurrentContext(), this.methodName);
        } else {
            Iterator<String> iterator = Arrays.asList(strings).iterator();
            this.methodName = iterator.next();
            ArrayList<IRubyObject> arguments = new ArrayList<IRubyObject>();
            while (iterator.hasNext()) {
                arguments.add(JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)iterator.next()));
            }
            result = this.rubyObject.callMethod(runtime.getCurrentContext(), this.methodName, arguments.toArray(new IRubyObject[arguments.size()]));
        }
        return result;
    }
}

