/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.waffle.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.waffle.WaffleException;
import org.codehaus.waffle.context.RequestLevelContainer;
import org.codehaus.waffle.controller.RubyController;
import org.codehaus.waffle.controller.ScriptedController;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RhtmlServlet
extends HttpServlet {
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String template = this.loadRhtml(request.getServletPath());
        Ruby runtime = (Ruby)RequestLevelContainer.get().getComponent(Ruby.class);
        RubyModule module = runtime.getClassFromPath("ERB");
        IRubyObject erb = (IRubyObject)JavaEmbedUtils.invokeMethod((Ruby)runtime, (Object)module, (String)"new", (Object[])new Object[]{JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)template)}, IRubyObject.class);
        Object controller = this.extractController(request);
        IRubyObject binding = (IRubyObject)JavaEmbedUtils.invokeMethod((Ruby)runtime, (Object)controller, (String)"send", (Object[])new Object[]{runtime.newSymbol("binding")}, IRubyObject.class);
        String out = (String)JavaEmbedUtils.invokeMethod((Ruby)runtime, (Object)erb, (String)"result", (Object[])new Object[]{binding}, String.class);
        response.getOutputStream().println(out);
        response.getOutputStream().flush();
    }

    private Object extractController(HttpServletRequest request) {
        Object controller = request.getAttribute("controller");
        if (controller instanceof RubyController) {
            controller = ((ScriptedController)controller).getScriptObject();
        }
        return controller;
    }

    private String loadRhtml(String resource) {
        this.log("Loading...." + resource);
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            inputStream = this.getServletContext().getResourceAsStream(resource);
            if (inputStream == null) {
                throw new IOException("Failed to find resource " + resource + " in servlet context");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder script = new StringBuilder();
            String line = bufferedReader.readLine();
            while (line != null) {
                script.append(line).append("\n");
                line = bufferedReader.readLine();
            }
            String string = script.toString();
            return string;
        }
        catch (IOException e) {
            throw new WaffleException((Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException ignore) {}
        }
    }
}

