/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.MavenSessionUtils;
import org.codehaus.tycho.TargetPlatform;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.codehaus.tycho.osgitools.features.FeatureDescriptionImpl;
import org.osgi.framework.Version;

@Component(role=FeatureResolutionState.class)
public class FeatureResolutionState
extends AbstractLogEnabled {
    private Map<String, FeatureDescription> features = new LinkedHashMap<String, FeatureDescription>();
    private static final Version VERSION_0_0_0 = new Version("0.0.0");

    public FeatureResolutionState(Logger logger, MavenSession session, TargetPlatform platform) {
        this.enableLogging(logger);
        for (File location : platform.getArtifactFiles("eclipse-feature")) {
            try {
                Feature feature = location.isDirectory() ? Feature.read(new File(location, "feature.xml")) : Feature.readJar(location);
                FeatureDescriptionImpl description = new FeatureDescriptionImpl(feature, location);
                description.setMavenProject(MavenSessionUtils.getMavenProject(session, location));
                String key = description.getId() + "_" + description.getVersion().toString();
                this.features.put(key, description);
            }
            catch (IOException e) {
                this.getLogger().warn("Could not read feature " + location, (Throwable)e);
            }
            catch (XmlPullParserException e) {
                this.getLogger().warn("Could not parse feature " + location, (Throwable)e);
            }
        }
    }

    public FeatureDescription getFeatureByLocation(File location) {
        for (FeatureDescription feature : this.features.values()) {
            if (!feature.getLocation().equals(location)) continue;
            return feature;
        }
        return null;
    }

    public FeatureDescription getFeature(String id, String version) {
        boolean qualified;
        if (id == null) {
            return null;
        }
        TreeMap<Version, FeatureDescription> features = new TreeMap<Version, FeatureDescription>(new Comparator<Version>(){

            @Override
            public int compare(Version o1, Version o2) {
                return -o1.compareTo((Object)o2);
            }
        });
        for (FeatureDescription desc : this.features.values()) {
            if (!id.equals(desc.getId())) continue;
            features.put(desc.getVersion(), desc);
        }
        if (features.isEmpty()) {
            return null;
        }
        if (version == null || version == "highest version") {
            return (FeatureDescription)features.get(features.firstKey());
        }
        Version parsedVersion = new Version(version);
        if (VERSION_0_0_0.equals((Object)parsedVersion)) {
            return (FeatureDescription)features.get(features.firstKey());
        }
        FeatureDescription perfectMatch = (FeatureDescription)features.get(parsedVersion);
        if (perfectMatch != null) {
            return perfectMatch;
        }
        boolean bl = qualified = !"".equals(parsedVersion.getQualifier());
        if (qualified) {
            return null;
        }
        for (FeatureDescription desc : features.values()) {
            if (!FeatureResolutionState.baseVersionEquals(parsedVersion, desc.getVersion())) continue;
            return desc;
        }
        return null;
    }

    private static boolean baseVersionEquals(Version v1, Version v2) {
        return v1.getMajor() == v2.getMajor() && v1.getMinor() == v2.getMinor() && v1.getMicro() == v2.getMicro();
    }
}

