/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.tycho.maven.DependenciesReader;
import org.codehaus.tycho.model.ProductConfiguration;
import org.codehaus.tycho.osgitools.AbstractDependenciesReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DependenciesReader.class, hint="eclipse-application")
public class EclipseApplicationDependenciesReader
extends AbstractDependenciesReader {
    @Override
    public List<Dependency> getDependencies(MavenSession session, MavenProject project) throws MavenExecutionException {
        ProductConfiguration product;
        String productFilename = project.getArtifactId() + ".product";
        File productFile = new File(project.getBasedir(), productFilename);
        if (!productFile.exists()) {
            this.getLogger().warn("product file not found at " + productFile.getAbsolutePath());
            return NO_DEPENDENCIES;
        }
        try {
            product = ProductConfiguration.read(productFile);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (null == m) {
                m = e.getClass().getName();
            }
            MavenExecutionException me = new MavenExecutionException(m, project.getFile());
            me.initCause((Throwable)e);
            throw me;
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        result.addAll(this.getPluginsDependencies(project, product.getPlugins(), session));
        result.addAll(this.getFeaturesDependencies(project, product.getFeatures(), session));
        return new ArrayList<Dependency>(result);
    }
}

