/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import copy.org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.tycho.BundleResolutionState;
import org.codehaus.tycho.ExecutionEnvironmentUtils;
import org.codehaus.tycho.TargetEnvironment;
import org.codehaus.tycho.TargetPlatform;
import org.codehaus.tycho.TychoConstants;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=BundleResolutionState.class, instantiationStrategy="per-lookup")
public class EquinoxBundleResolutionState
extends AbstractLogEnabled
implements BundleResolutionState {
    private static final String PROP_MANIFEST = "BundleManifest";
    private static StateObjectFactory factory = StateObjectFactory.defaultFactory;
    private final State state = factory.createState(true);
    private long nextBundleId;
    private File manifestsDir;
    private static final Map<File, Manifest> manifestCache = new HashMap<File, Manifest>();

    public BundleDescription addBundle(File bundleLocation, boolean override) throws BundleException {
        if (bundleLocation == null || !bundleLocation.exists()) {
            throw new IllegalArgumentException("bundleLocation not found: " + bundleLocation);
        }
        Dictionary manifest = this.loadBundleManifest(bundleLocation);
        if (manifest == null) {
            throw new BundleException("Manifest not found in " + bundleLocation);
        }
        return this.addBundle(manifest, bundleLocation, override);
    }

    private BundleDescription addBundle(Dictionary enhancedManifest, File bundleLocation, boolean override) throws BundleException {
        BundleDescription[] conflicts;
        BundleDescription descriptor = factory.createBundleDescription(this.state, enhancedManifest, bundleLocation.getAbsolutePath(), this.getNextBundleId());
        EquinoxBundleResolutionState.setUserProperty(descriptor, PROP_MANIFEST, enhancedManifest);
        if (override && (conflicts = this.state.getBundles(descriptor.getSymbolicName())) != null) {
            for (BundleDescription conflict : conflicts) {
                this.state.removeBundle(conflict);
                this.getLogger().warn(conflict.toString() + " has been replaced by another bundle with the same symbolic name " + descriptor.toString());
            }
        }
        this.state.addBundle(descriptor);
        return descriptor;
    }

    private long getNextBundleId() {
        return this.nextBundleId++;
    }

    @Override
    public void assertResolved(BundleDescription desc) throws BundleException {
        if (!desc.isResolved()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Bundle ").append(desc.getSymbolicName()).append(" cannot be resolved\n");
            msg.append("Resolution errors:\n");
            ResolverError[] errors = this.getResolverErrors(desc);
            for (int i = 0; i < errors.length; ++i) {
                ResolverError error = errors[i];
                msg.append("   Bundle ").append(error.getBundle().getSymbolicName()).append(" - ").append(error.toString()).append("\n");
            }
            throw new BundleException(msg.toString());
        }
    }

    public ResolverError[] getResolverErrors(BundleDescription bundle) {
        LinkedHashSet<ResolverError> errors = new LinkedHashSet<ResolverError>();
        this.getRelevantErrors(errors, bundle);
        return errors.toArray(new ResolverError[errors.size()]);
    }

    private void getRelevantErrors(Set<ResolverError> errors, BundleDescription bundle) {
        ResolverError[] bundleErrors = this.state.getResolverErrors(bundle);
        for (int j = 0; j < bundleErrors.length; ++j) {
            ResolverError error = bundleErrors[j];
            errors.add(error);
            VersionConstraint constraint = error.getUnsatisfiedConstraint();
            if (!(constraint instanceof BundleSpecification) && !(constraint instanceof HostSpecification)) continue;
            BundleDescription[] requiredBundles = this.state.getBundles(constraint.getName());
            for (int i = 0; i < requiredBundles.length; ++i) {
                this.getRelevantErrors(errors, requiredBundles[i]);
            }
        }
    }

    @Override
    public BundleDescription getBundle(String symbolicName, String version) {
        try {
            if ("highest version" == version) {
                return this.getLatestBundle(symbolicName);
            }
            return this.state.getBundle(symbolicName, new Version(version));
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private BundleDescription getLatestBundle(String symbolicName) {
        BundleDescription[] bundles = this.state.getBundles(symbolicName);
        BundleDescription highest = null;
        if (bundles != null) {
            for (BundleDescription desc : bundles) {
                if (highest != null && highest.getVersion().compareTo((Object)desc.getVersion()) >= 0) continue;
                highest = desc;
            }
        }
        return highest;
    }

    @Override
    public BundleDescription getBundleByLocation(File location) {
        String absolutePath = location.getAbsolutePath();
        return this.state.getBundleByLocation(absolutePath);
    }

    @Override
    public List<BundleDescription> getDependencies(BundleDescription bundle) {
        LinkedHashSet<Long> bundleIds = new LinkedHashSet<Long>();
        EquinoxBundleResolutionState.addBundleAndDependencies(bundle, bundleIds, true);
        ArrayList<BundleDescription> dependencies = new ArrayList<BundleDescription>();
        Iterator i$ = bundleIds.iterator();
        while (i$.hasNext()) {
            BundleDescription dependency;
            long bundleId = (Long)i$.next();
            if (bundle.getBundleId() == bundleId || (dependency = this.state.getBundle(bundleId)) == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private static void addBundleAndDependencies(BundleDescription desc, Set<Long> bundleIds, boolean includeOptional) {
        if (desc != null && bundleIds.add(new Long(desc.getBundleId()))) {
            BundleSpecification[] required = desc.getRequiredBundles();
            for (int i = 0; i < required.length; ++i) {
                if (!includeOptional && required[i].isOptional()) continue;
                EquinoxBundleResolutionState.addBundleAndDependencies((BundleDescription)required[i].getSupplier(), bundleIds, includeOptional);
            }
            ImportPackageSpecification[] importedPkgs = desc.getImportPackages();
            for (int i = 0; i < importedPkgs.length; ++i) {
                ExportPackageDescription exporter = (ExportPackageDescription)importedPkgs[i].getSupplier();
                if (exporter == null || !includeOptional && "optional".equals(importedPkgs[i].getDirective("resolution"))) continue;
                EquinoxBundleResolutionState.addBundleAndDependencies(exporter.getExporter(), bundleIds, includeOptional);
            }
            BundleDescription[] fragments = desc.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                String id;
                if (!fragments[i].isResolved() || "org.eclipse.ui.workbench.compatibility".equals(id = fragments[i].getSymbolicName())) continue;
                EquinoxBundleResolutionState.addBundleAndDependencies(fragments[i], bundleIds, includeOptional);
            }
            HostSpecification host = desc.getHost();
            if (host != null) {
                EquinoxBundleResolutionState.addBundleAndDependencies((BundleDescription)host.getSupplier(), bundleIds, includeOptional);
            }
        }
    }

    @Override
    public StateHelper getStateHelper() {
        return this.state.getStateHelper();
    }

    @Override
    public BundleDescription getSystemBundle() {
        return this.getLatestBundle("org.eclipse.osgi");
    }

    @Override
    public List<BundleDescription> getBundles() {
        return Arrays.asList(this.state.getBundles());
    }

    @Override
    public Manifest loadManifest(File bundleLocation) {
        Manifest manifest = manifestCache.get(bundleLocation);
        if (manifest == null) {
            manifest = this.doLoadManifest(bundleLocation);
            manifestCache.put(bundleLocation, manifest);
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest doLoadManifest(File bundleLocation) {
        try {
            block15: {
                if (bundleLocation.isDirectory()) {
                    File m = new File(bundleLocation, "META-INF/MANIFEST.MF");
                    if (m.canRead()) {
                        return this.loadManifestFile(m);
                    }
                    m = this.convertPluginManifest(bundleLocation);
                    if (m == null) return null;
                    if (!m.canRead()) return null;
                    return this.loadManifestFile(m);
                }
                if (!bundleLocation.canRead()) {
                    return null;
                }
                if (!bundleLocation.getName().toLowerCase().endsWith(".jar")) {
                    return this.loadManifestFile(bundleLocation);
                }
                ZipFile jar = new ZipFile(bundleLocation, 1);
                try {
                    ZipEntry me = jar.getEntry("META-INF/MANIFEST.MF");
                    if (me == null) break block15;
                    InputStream is = jar.getInputStream(me);
                    try {
                        Manifest mf = new Manifest(is);
                        if (mf.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
                            Manifest manifest = mf;
                            return manifest;
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    jar.close();
                }
            }
            File m = this.convertPluginManifest(bundleLocation);
            if (m == null) return null;
            if (!m.canRead()) return null;
            return this.loadManifestFile(m);
        }
        catch (IOException e) {
            this.getLogger().warn("Exception reading bundle manifest", (Throwable)e);
            return null;
        }
        catch (PluginConversionException e) {
            this.getLogger().warn("Exception reading bundle manifest: " + e.getMessage());
        }
        return null;
    }

    @Override
    public String getManifestAttribute(BundleDescription bundle, String name) {
        Dictionary mf = (Dictionary)EquinoxBundleResolutionState.getUserProperty(bundle, PROP_MANIFEST);
        if (mf != null) {
            return (String)mf.get(name);
        }
        return null;
    }

    public Dictionary loadBundleManifest(File bundleLocation) {
        Manifest m = this.loadManifest(bundleLocation);
        if (m == null) {
            return null;
        }
        Properties manifest = EquinoxBundleResolutionState.manifestToProperties(m.getMainAttributes());
        if (((Dictionary)manifest).get("Bundle-SymbolicName") == null) {
            return null;
        }
        if (((Dictionary)manifest).get("Bundle-ClassPath") == null) {
            ((Dictionary)manifest).put("Bundle-ClassPath", ".");
        }
        return manifest;
    }

    private static Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest loadManifestFile(File m) throws IOException {
        if (!m.canRead()) {
            return null;
        }
        FileInputStream is = new FileInputStream(m);
        try {
            Manifest manifest = new Manifest(is);
            return manifest;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    private File convertPluginManifest(File bundleLocation) throws PluginConversionException {
        PluginConverterImpl converter = new PluginConverterImpl(null, null);
        String name = bundleLocation.getName();
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - 4);
        }
        File manifestFile = new File(this.manifestsDir, name + "/META-INF/MANIFEST.MF");
        manifestFile.getParentFile().mkdirs();
        converter.convertManifest(bundleLocation, manifestFile, false, "3.2", true, null);
        if (manifestFile.exists()) {
            return manifestFile;
        }
        return null;
    }

    public static EquinoxBundleResolutionState newInstance(PlexusContainer plexus, MavenSession session, MavenProject project) {
        try {
            boolean isProject;
            EquinoxBundleResolutionState resolver = (EquinoxBundleResolutionState)plexus.lookup(BundleResolutionState.class);
            HashSet<File> basedirs = new HashSet<File>();
            for (MavenProject sessionProject : session.getProjects()) {
                basedirs.add(sessionProject.getBasedir());
            }
            TargetPlatform platform = (TargetPlatform)project.getContextValue(TychoConstants.CTX_TARGET_PLATFORM);
            File manifestsDir = new File(project.getBuild().getDirectory(), "manifests");
            manifestsDir.mkdirs();
            resolver.setManifestsDir(manifestsDir);
            for (File file : platform.getArtifactFiles("eclipse-plugin")) {
                isProject = basedirs.contains(file);
                resolver.addBundle(file, isProject);
            }
            for (File file : platform.getArtifactFiles("eclipse-test-plugin")) {
                isProject = basedirs.contains(file);
                resolver.addBundle(file, isProject);
            }
            resolver.resolve(project);
            return resolver;
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Could not lookup required component", e);
        }
        catch (BundleException e) {
            throw new RuntimeException("Unable to initialize BundleResolutionState", e);
        }
    }

    public void setManifestsDir(File manifestsDir) {
        this.manifestsDir = manifestsDir;
    }

    public File getManifestsDir() {
        return this.manifestsDir;
    }

    public void resolve(MavenProject project) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)((Properties)project.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES)));
        TargetEnvironment environment = (TargetEnvironment)project.getContextValue(TychoConstants.CTX_TARGET_ENVIRONMENT);
        properties.put("osgi.os", environment.getOs());
        properties.put("osgi.ws", environment.getWs());
        properties.put("osgi.arch", environment.getArch());
        ExecutionEnvironmentUtils.loadVMProfile(properties);
        properties.put("osgi.resolverMode", "development");
        this.state.setPlatformProperties((Dictionary)properties);
        this.state.resolve(false);
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Resolved OSGi state\n");
            for (BundleDescription bundle : this.state.getBundles()) {
                if (!bundle.isResolved()) {
                    sb.append("NOT ");
                }
                sb.append("RESOLVED ");
                sb.append(bundle.toString()).append(" : ").append(bundle.getLocation());
                sb.append('\n');
                for (ResolverError error : this.state.getResolverErrors(bundle)) {
                    sb.append('\t').append(error.toString()).append('\n');
                }
            }
            this.getLogger().debug(sb.toString());
        }
    }

    private static void setUserProperty(BundleDescription desc, String name, Object value) {
        Object userObject = desc.getUserObject();
        if (userObject != null && !(userObject instanceof Map)) {
            throw new IllegalStateException("Unexpected user object " + desc.toString());
        }
        HashMap<String, Object> props = (HashMap<String, Object>)userObject;
        if (props == null) {
            props = new HashMap<String, Object>();
            desc.setUserObject(props);
        }
        props.put(name, value);
    }

    private static Object getUserProperty(BundleDescription desc, String name) {
        if (desc == null) {
            return null;
        }
        Object userObject = desc.getUserObject();
        if (userObject instanceof Map) {
            return ((Map)userObject).get(name);
        }
        return null;
    }
}

