/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.tycho.BundleResolutionState;
import org.codehaus.tycho.FeatureResolutionState;
import org.codehaus.tycho.TargetPlatform;
import org.codehaus.tycho.TychoSession;
import org.codehaus.tycho.osgitools.EquinoxBundleResolutionState;
import org.codehaus.tycho.osgitools.project.EclipsePluginProject;
import org.codehaus.tycho.osgitools.project.EclipsePluginProjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MutableTychoSession.class, instantiationStrategy="per-lookup")
public class MutableTychoSession
extends AbstractLogEnabled
implements TychoSession {
    @Requirement
    PlexusContainer plexus;
    private Map<File, MavenProject> projects = new LinkedHashMap<File, MavenProject>();
    private Map<File, TargetPlatform> platforms = new LinkedHashMap<File, TargetPlatform>();
    private Map<File, BundleResolutionState> bundleResolvers = new LinkedHashMap<File, BundleResolutionState>();
    private Map<File, FeatureResolutionState> featureResolvers = new LinkedHashMap<File, FeatureResolutionState>();
    private Map<File, EclipsePluginProject> pdeProjects = new LinkedHashMap<File, EclipsePluginProject>();
    private Map<String, Object> sessionContext = new HashMap<String, Object>();

    @Override
    public BundleResolutionState getBundleResolutionState(MavenProject project) {
        File basedir = project.getBasedir();
        BundleResolutionState resolver = null;
        if (this.bundleResolvers.containsKey(basedir)) {
            resolver = this.bundleResolvers.get(basedir);
        } else {
            TargetPlatform platform = this.platforms.get(basedir);
            if (platform != null) {
                resolver = EquinoxBundleResolutionState.newInstance(this.plexus, this, project);
            }
            this.bundleResolvers.put(basedir, resolver);
        }
        return resolver;
    }

    @Override
    public FeatureResolutionState getFeatureResolutionState(MavenProject project) {
        File basedir = project.getBasedir();
        FeatureResolutionState resolver = null;
        if (this.featureResolvers.containsKey(basedir)) {
            resolver = this.featureResolvers.get(basedir);
        } else {
            TargetPlatform platform = this.platforms.get(basedir);
            if (platform != null) {
                resolver = new FeatureResolutionState(this.getLogger(), this, platform);
            }
            this.featureResolvers.put(basedir, resolver);
        }
        return resolver;
    }

    @Override
    public MavenProject getMavenProject(File location) {
        return this.projects.get(location);
    }

    @Override
    public MavenProject getMavenProject(String location) {
        return this.getMavenProject(new File(location));
    }

    public void setTargetPlatform(MavenProject project, TargetPlatform platform) {
        File basedir = project.getBasedir();
        this.projects.put(basedir, project);
        this.platforms.put(basedir, platform);
    }

    public void setProjects(List<MavenProject> projects) {
        for (MavenProject project : projects) {
            this.projects.put(project.getBasedir(), project);
        }
    }

    @Override
    public TargetPlatform getTargetPlatform(MavenProject project) {
        return this.platforms.get(project.getBasedir());
    }

    @Override
    public EclipsePluginProject getEclipsePluginProject(MavenProject project) {
        EclipsePluginProject pdeProject = this.pdeProjects.get(project.getBasedir());
        if (pdeProject == null) {
            BundleResolutionState resolver = this.getBundleResolutionState(project);
            try {
                pdeProject = new EclipsePluginProjectImpl(project, resolver.getBundleByLocation(project.getBasedir()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.pdeProjects.put(project.getBasedir(), pdeProject);
        }
        return pdeProject;
    }

    @Override
    public Map<String, Object> getSessionContext() {
        return this.sessionContext;
    }
}

