/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Profile;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.tycho.TargetPlatformResolver;
import org.codehaus.tycho.TychoSession;
import org.codehaus.tycho.maven.DependenciesReader;
import org.codehaus.tycho.maven.TychoMavenSession;
import org.codehaus.tycho.osgitools.MutableTychoSession;
import org.codehaus.tycho.osgitools.targetplatform.LocalTargetPlatformResolver;
import org.codehaus.tycho.osgitools.utils.TychoVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=Maven.class)
public class EclipseMaven
extends DefaultMaven {
    private MutableTychoSession tychoSession;

    protected List getProjects(MavenExecutionRequest request) throws MavenExecutionException {
        request.setProperty("tycho-version", TychoVersion.getTychoVersion());
        List projects = super.getProjects(request);
        this.resolveOSGiState(projects, request);
        return projects;
    }

    protected MavenSession createSession(MavenExecutionRequest request, ReactorManager reactorManager, EventDispatcher dispatcher) {
        TychoMavenSession session = new TychoMavenSession(this.container, request, dispatcher, reactorManager, this.tychoSession);
        return session;
    }

    @Deprecated
    public TychoSession getTychoSession() {
        return this.tychoSession;
    }

    private void resolveOSGiState(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        this.tychoSession = this.newTychoSession();
        this.tychoSession.setProjects(projects);
        Properties properties = EclipseMaven.getGlobalProperties(request);
        for (MavenProject project : projects) {
            TargetPlatformResolver resolver = EclipseMaven.lookupPlatformResolver(this.container, properties);
            resolver.setLocalRepository(request.getLocalRepository());
            resolver.setMavenProjects(projects);
            resolver.setProperties(properties);
            try {
                DependenciesReader dr = (DependenciesReader)this.container.lookup(DependenciesReader.class, project.getPackaging());
                this.tychoSession.setTargetPlatform(project, resolver.resolvePlatform(project, null));
                for (Dependency dependency : dr.getDependencies(project, this.tychoSession)) {
                    project.getModel().addDependency(dependency);
                }
            }
            catch (ComponentLookupException e) {
            }
        }
    }

    public static TargetPlatformResolver lookupPlatformResolver(PlexusContainer container, Properties properties) {
        TargetPlatformResolver resolver;
        String property = properties.getProperty("tycho.targetPlatform");
        if (property != null) {
            TargetPlatformResolver resolver2;
            File location = new File(property);
            if (!location.exists() || !location.isDirectory()) {
                throw new RuntimeException("Invalid target platform location");
            }
            try {
                resolver2 = (TargetPlatformResolver)container.lookup(TargetPlatformResolver.class, "local");
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException("Could not instantiate required component", e);
            }
            ((LocalTargetPlatformResolver)resolver2).setLocation(new File(property));
            return resolver2;
        }
        String resolverRole = properties.getProperty("tycho.resolver", "tycho03");
        try {
            resolver = (TargetPlatformResolver)container.lookup(TargetPlatformResolver.class, resolverRole);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Could not instantiate required component", e);
        }
        return resolver;
    }

    private MutableTychoSession newTychoSession() throws MavenExecutionException {
        try {
            return (MutableTychoSession)this.container.lookup(MutableTychoSession.class);
        }
        catch (ComponentLookupException e) {
            throw new MavenExecutionException(e.getMessage(), new IOException());
        }
    }

    private static Properties getGlobalProperties(MavenExecutionRequest request) {
        List activeProfiles = request.getActiveProfiles();
        Map profiles = request.getProfileManager().getProfilesById();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        for (Profile profile : profiles.values()) {
            Activation activation = profile.getActivation();
            if ((activation == null || !activation.isActiveByDefault()) && !activeProfiles.contains(profile.getId())) continue;
            props.putAll((Map<?, ?>)profile.getProperties());
        }
        props.putAll((Map<?, ?>)request.getProperties());
        props.putAll((Map<?, ?>)request.getUserProperties());
        return props;
    }
}

