/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.tycho.ExecutionEnvironmentUtils;
import org.codehaus.tycho.PlatformPropertiesUtils;
import org.codehaus.tycho.TargetPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTargetPlatform
implements TargetPlatform {
    private Map<File, String> artifacts = new LinkedHashMap<File, String>();
    private Properties properties;
    private Set<File> sites = new LinkedHashSet<File>();

    @Override
    public List<File> getArtifactFiles(String ... artifactTypes) {
        ArrayList<File> result = new ArrayList<File>();
        block0: for (Map.Entry<File, String> entry : this.artifacts.entrySet()) {
            for (String type : artifactTypes) {
                if (!type.equals(entry.getValue())) continue;
                result.add(entry.getKey());
                continue block0;
            }
        }
        return result;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void addArtifactFile(String artifactType, File artifactFile) {
        this.artifacts.put(artifactFile, artifactType);
    }

    public void setProperties(Properties properties) {
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
        this.properties.put("osgi.os", PlatformPropertiesUtils.getOS(this.properties));
        this.properties.put("osgi.ws", PlatformPropertiesUtils.getWS(this.properties));
        this.properties.put("osgi.arch", PlatformPropertiesUtils.getArch(this.properties));
        ExecutionEnvironmentUtils.loadVMProfile(this.properties);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void addSite(File location) {
        this.sites.add(location);
    }

    @Override
    public List<File> getSites() {
        return new ArrayList<File>(this.sites);
    }
}

