/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.p2;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.tycho.osgitools.utils.PlatformPropertiesUtils;
import org.codehaus.tycho.p2.P2;
import org.eclipse.core.runtime.adaptor.EclipseStarter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=P2.class)
public class DefaultP2
extends AbstractLogEnabled
implements P2 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String materializeTargetPlatform(String key, List<String> repositories, List<Artifact> rootIUs, Properties props) throws MavenExecutionException {
        String string;
        System.setProperty("osgi.framework.useSystemProperties", "false");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osgi.install.area", this.getP2RuntimeLocation());
        properties.put("osgi.syspath", this.getP2RuntimeLocation() + "/plugins");
        properties.put("osgi.configuration.area", this.getP2RuntimeLocation() + "/configuration");
        properties.put("eclipse.p2.data.area", this.getPPBase() + "/p2");
        String[] args = new String[]{"-application", "org.codehaus.tycho.p2.materializeTargetPlatform", "-install", this.getP2RuntimeLocation()};
        HashMap<String, Object> appArgs = new HashMap<String, Object>();
        appArgs.put("-p2base", this.getPPBase());
        appArgs.put("-profile", key);
        appArgs.put("-repositories", repositories);
        appArgs.put("-environments", this.getEnvironments(props));
        HashMap<String, String> rootIUVersionMap = new HashMap<String, String>();
        for (Artifact rootIU : rootIUs) {
            rootIUVersionMap.put(rootIU.getArtifactId(), rootIU.getVersion());
        }
        appArgs.put("-rootIUs", rootIUVersionMap);
        appArgs.put("-logger", this.getLogger());
        EclipseStarter.setInitialProperties(properties);
        EclipseStarter.startup((String[])args, null);
        try {
            string = (String)EclipseStarter.run(appArgs);
        }
        catch (Throwable throwable) {
            try {
                EclipseStarter.shutdown();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MavenExecutionException(e.getMessage(), (IOException)null);
            }
        }
        EclipseStarter.shutdown();
        return string;
    }

    private String getPPBase() throws MavenExecutionException {
        String property = System.getProperty("tycho.p2.data");
        File bundleLocation = property != null ? new File(property) : new File(System.getProperty("user.home"), ".m2/p2");
        try {
            bundleLocation.mkdirs();
            String location = bundleLocation.getCanonicalPath().replace('\\', '/');
            this.getLogger().info("Using p2 data area " + location);
            return location;
        }
        catch (IOException e) {
            throw new MavenExecutionException("Can't determine p2 bundle pool location", e);
        }
    }

    @Override
    public String getP2RuntimeLocation() throws MavenExecutionException {
        File ppLocation;
        String property = System.getProperty("tycho.p2.location");
        if (property == null) {
            property = System.getProperty("maven.home");
            if (property == null) {
                throw new MavenExecutionException("Can't locate p2 installation location (either maven.home or tycho.p2.location system property must be set)", (IOException)null);
            }
            ppLocation = new File(property, "p2");
        } else {
            ppLocation = new File(property);
        }
        try {
            String location = new File(ppLocation, "eclipse").getCanonicalPath().replace('\\', '/');
            this.getLogger().info("Using tycho p2 runtime " + location);
            return location;
        }
        catch (IOException e) {
            throw new MavenExecutionException("Can't locate p2 installation location", e);
        }
    }

    private String getEnvironments(Properties props) {
        StringBuilder sb = new StringBuilder();
        sb.append("osgi.os=").append(PlatformPropertiesUtils.getOS(props));
        sb.append(",osgi.ws=").append(PlatformPropertiesUtils.getWS(props));
        sb.append(",osgi.arch=").append(PlatformPropertiesUtils.getArch(props));
        return sb.toString();
    }
}

