/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.tycho.maven.DependenciesReader;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.PluginRef;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependenciesReader
extends AbstractLogEnabled
implements DependenciesReader {
    protected static final List<Dependency> NO_DEPENDENCIES = new ArrayList<Dependency>();
    @Requirement
    protected OsgiState state;

    protected Dependency newExternalDependency(String location, String groupId, String artifactId, String version) {
        File file = new File(location);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            this.getLogger().warn("Dependency at location " + location + " can not be represented in Maven model and will not be visible to non-OSGi aware Maven plugins");
            return null;
        }
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifactId);
        dependency.setGroupId(groupId);
        dependency.setVersion(version);
        dependency.setScope(Artifact.SCOPE_SYSTEM);
        dependency.setSystemPath(location);
        return dependency;
    }

    protected Dependency newProjectDependency(MavenProject otherProject) {
        if (otherProject == null) {
            return null;
        }
        Dependency dependency = new Dependency();
        dependency.setArtifactId(otherProject.getArtifactId());
        dependency.setGroupId(otherProject.getGroupId());
        dependency.setVersion(otherProject.getVersion());
        dependency.setType(otherProject.getPackaging());
        dependency.setScope(Artifact.SCOPE_PROVIDED);
        return dependency;
    }

    protected Collection<? extends Dependency> getFeaturesDependencies(List<Feature.FeatureRef> features) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Feature.FeatureRef featureRef : features) {
            Dependency dependency;
            FeatureDescription otherFeature = this.state.getFeatureDescription(featureRef.getId(), featureRef.getVersion());
            if (otherFeature == null || (dependency = this.newProjectDependency(this.state.getMavenProject(otherFeature))) == null) continue;
            result.add(dependency);
        }
        return result;
    }

    protected Collection<? extends Dependency> getPluginsDependencies(List<PluginRef> plugins) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (PluginRef pluginRef : plugins) {
            Dependency dependency;
            BundleDescription bundle = this.state.getBundleDescription(pluginRef.getId(), this.getPluginVersion(pluginRef.getVersion()));
            if (bundle == null || (dependency = this.newProjectDependency(this.state.getMavenProject(bundle))) == null) continue;
            result.add(dependency);
        }
        return result;
    }

    private String getPluginVersion(String version) {
        return version == null || "0.0.0".equals(version) ? "highest version" : version;
    }
}

