/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    public static final String ICON_LINUX = "icon";
    public static final String ICON_MAC = "icon";
    public static final String ICON_WINDOWS_ICO_PATH = "path";
    public static final String ICON_WINDOWS_LARGE_LOW = "winLargeLow";
    public static final String ICON_WINDOWS_LARGE_HIGH = "winLargeHigh";
    public static final String ICON_WINDOWS_MEDIUM_LOW = "winMediumLow";
    public static final String ICON_WINDOWS_MEDIUM_HIGH = "winMediumHigh";
    public static final String ICON_WINDOWS_SMALL_LOW = "winSmallLow";
    public static final String ICON_WINDOWS_SMALL_HIGH = "winSmallHigh";
    public static final String ICON_SOLARIS_TINY = "solarisTiny";
    public static final String ICON_SOLARIS_SMALL = "solarisSmall";
    public static final String ICON_SOLARIS_MEDIUM = "solarisMedium";
    public static final String ICON_SOLARIS_LARGE = "solarisLarge";
    private Xpp3Dom dom;

    public Launcher(Xpp3Dom dom) {
        this.dom = dom;
    }

    public String getName() {
        return this.dom.getAttribute("name");
    }

    public Map<String, String> getLinuxIcon() {
        Xpp3Dom linuxDom = this.dom.getChild("linux");
        if (linuxDom == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> linux = new HashMap<String, String>();
        this.putIfNotNull(linux, "icon", linuxDom.getAttribute("icon"));
        return Collections.unmodifiableMap(linux);
    }

    public Map<String, String> getMacosxIcon() {
        Xpp3Dom macosxDom = this.dom.getChild("macosx");
        if (macosxDom == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> mac = new HashMap<String, String>();
        this.putIfNotNull(mac, "icon", macosxDom.getAttribute("icon"));
        return Collections.unmodifiableMap(mac);
    }

    public Map<String, String> getSolarisIcon() {
        Xpp3Dom solarisDom = this.dom.getChild("solaris");
        if (solarisDom == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> solaris = new HashMap<String, String>();
        this.putIfNotNull(solaris, ICON_SOLARIS_LARGE, solarisDom.getAttribute(ICON_SOLARIS_LARGE));
        this.putIfNotNull(solaris, ICON_SOLARIS_MEDIUM, solarisDom.getAttribute(ICON_SOLARIS_MEDIUM));
        this.putIfNotNull(solaris, ICON_SOLARIS_SMALL, solarisDom.getAttribute(ICON_SOLARIS_SMALL));
        this.putIfNotNull(solaris, ICON_SOLARIS_TINY, solarisDom.getAttribute(ICON_SOLARIS_TINY));
        return Collections.unmodifiableMap(solaris);
    }

    public boolean getWindowsUseIco() {
        Xpp3Dom winDom = this.dom.getChild("win");
        if (winDom == null) {
            return false;
        }
        boolean useIco = Boolean.parseBoolean(winDom.getAttribute("useIco"));
        return useIco;
    }

    public Map<String, String> getWindowsIcon() {
        Xpp3Dom winDom = this.dom.getChild("win");
        if (winDom == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> windows = new HashMap<String, String>();
        if (this.getWindowsUseIco()) {
            Xpp3Dom ico = winDom.getChild("ico");
            if (ico != null) {
                this.putIfNotNull(windows, ICON_WINDOWS_ICO_PATH, ico.getAttribute(ICON_WINDOWS_ICO_PATH));
            }
        } else {
            Xpp3Dom bmp = winDom.getChild("bmp");
            if (bmp != null) {
                this.putIfNotNull(windows, ICON_WINDOWS_SMALL_HIGH, bmp.getAttribute(ICON_WINDOWS_SMALL_HIGH));
                this.putIfNotNull(windows, ICON_WINDOWS_SMALL_LOW, bmp.getAttribute(ICON_WINDOWS_SMALL_LOW));
                this.putIfNotNull(windows, ICON_WINDOWS_MEDIUM_HIGH, bmp.getAttribute(ICON_WINDOWS_MEDIUM_HIGH));
                this.putIfNotNull(windows, ICON_WINDOWS_MEDIUM_LOW, bmp.getAttribute(ICON_WINDOWS_MEDIUM_LOW));
                this.putIfNotNull(windows, ICON_WINDOWS_LARGE_HIGH, bmp.getAttribute(ICON_WINDOWS_LARGE_HIGH));
                this.putIfNotNull(windows, ICON_WINDOWS_LARGE_LOW, bmp.getAttribute(ICON_WINDOWS_LARGE_LOW));
            }
        }
        return Collections.unmodifiableMap(windows);
    }

    private void putIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

