/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.maven;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.DefaultMaven;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.tycho.maven.DependenciesReader;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.targetplatform.EclipseTargetPlatformFactory;
import org.codehaus.tycho.osgitools.utils.TychoVersion;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseMaven
extends DefaultMaven {
    private OsgiState state;
    private EclipseTargetPlatformFactory factory;

    protected List getProjects(MavenExecutionRequest request) throws MavenExecutionException {
        request.setProperty("tycho-version", TychoVersion.getTychoVersion());
        List projects = super.getProjects(request);
        this.resolveOSGiState(projects, request);
        return projects;
    }

    private void resolveOSGiState(List<MavenProject> projects, MavenExecutionRequest request) throws MavenExecutionException {
        Properties props = this.getGlobalProperties(request);
        String mode = props.getProperty("tycho.mode");
        if ("maven".equals(mode)) {
            return;
        }
        this.state.reset(props);
        String property = props.getProperty("tycho.targetPlatform");
        if (property != null) {
            this.getLogger().info("Build target platform tycho.targetPlatform=" + property + "\n. This overrides target platform specified in pom.xml files, if any.");
            this.factory.createTargetPlatform(this.state, new File(property));
        } else {
            this.factory.createTargetPlatform(projects, request.getLocalRepository(), this.state);
        }
        for (MavenProject project : projects) {
            try {
                this.state.addProject(project);
            }
            catch (BundleException e) {
                throw new MavenExecutionException(e.getMessage(), project.getFile());
            }
        }
        this.state.resolveState();
        for (MavenProject project : projects) {
            try {
                DependenciesReader dr = (DependenciesReader)this.container.lookup(DependenciesReader.class, project.getPackaging());
                if (dr == null) continue;
                for (Dependency dependency : dr.getDependencies(project)) {
                    project.getModel().addDependency(dependency);
                }
            }
            catch (ComponentLookupException e) {
            }
        }
    }

    private Properties getGlobalProperties(MavenExecutionRequest request) {
        List activeProfiles = request.getActiveProfiles();
        Map profiles = request.getProfileManager().getProfilesById();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        for (Profile profile : profiles.values()) {
            Activation activation = profile.getActivation();
            if ((activation == null || !activation.isActiveByDefault()) && !activeProfiles.contains(profile.getId())) continue;
            props.putAll((Map<?, ?>)profile.getProperties());
        }
        props.putAll((Map<?, ?>)request.getProperties());
        props.putAll((Map<?, ?>)request.getUserProperties());
        return props;
    }
}

