/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import copy.org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.osgitools.EclipsePluginPathFinder;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.utils.ExecutionEnvironmentUtils;
import org.codehaus.tycho.osgitools.utils.PlatformPropertiesUtils;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiStateController
extends AbstractLogEnabled
implements OsgiState {
    private static final String PROP_MAVEN_PROJECT = "MavenProject";
    private static final String PROP_MANIFEST = "BundleManifest";
    private StateObjectFactory factory = StateObjectFactory.defaultFactory;
    private State state;
    private long id = 0L;
    private Map patchBundles;
    private File outputDir;
    private Properties platformProperties;
    private File targetPlatform;
    private Map<String, Feature> features = new LinkedHashMap<String, Feature>();

    public static BundleDescription[] getDependentBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        BundleDescription[] imported = OsgiStateController.getImportedBundles(root);
        BundleDescription[] required = OsgiStateController.getRequiredBundles(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        ExportPackageDescription[] packages = root.getResolvedImports();
        ArrayList<BundleDescription> resolvedImports = new ArrayList<BundleDescription>(packages.length);
        for (int i = 0; i < packages.length; ++i) {
            if (root.getLocation().equals(packages[i].getExporter().getLocation()) || resolvedImports.contains(packages[i].getExporter())) continue;
            resolvedImports.add(packages[i].getExporter());
        }
        return resolvedImports.toArray(new BundleDescription[resolvedImports.size()]);
    }

    public static BundleDescription[] getRequiredBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        return root.getResolvedRequires();
    }

    public OsgiStateController() {
        this.patchBundles = new HashMap();
    }

    private void loadTargetPlatform(File platform, boolean forceP2) {
        this.getLogger().info("Using " + platform.getAbsolutePath() + " eclipse target platform");
        EclipsePluginPathFinder finder = new EclipsePluginPathFinder(forceP2, this.getLogger());
        Set<File> bundles = finder.getPlugins(platform);
        if (bundles == null || bundles.size() == 0) {
            throw new RuntimeException("No bundles found!");
        }
        this.getLogger().info("Found " + bundles.size() + " bundles");
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (File bundle : bundles) {
                sb.append('\t').append(bundle.getAbsolutePath()).append('\n');
            }
            this.getLogger().debug(sb.toString());
        }
        for (File bundle : bundles) {
            try {
                this.addBundle(bundle);
            }
            catch (BundleException e) {
                this.getLogger().info("Could not add bundle: " + bundle);
            }
        }
    }

    private long getNextId() {
        return ++this.id;
    }

    @Override
    public BundleDescription addBundle(File bundleLocation) throws BundleException {
        if (bundleLocation == null || !bundleLocation.exists()) {
            throw new IllegalArgumentException("bundleLocation not found: " + bundleLocation);
        }
        Dictionary manifest = this.loadManifestAttributes(bundleLocation);
        if (manifest == null) {
            throw new BundleException("manifest not found in " + bundleLocation);
        }
        return this.addBundle(manifest, bundleLocation, false);
    }

    public BundleDescription addBundle(File manifestLocation, File bundleLocation, boolean override) throws BundleException {
        if (bundleLocation == null || !bundleLocation.exists()) {
            throw new IllegalArgumentException("bundleLocation not found: " + bundleLocation);
        }
        Dictionary manifest = this.loadManifestAttributes(manifestLocation);
        if (manifest == null) {
            throw new IllegalArgumentException("manifest not found in " + manifestLocation);
        }
        return this.addBundle(manifest, bundleLocation, override);
    }

    private Dictionary loadManifestAttributes(File bundleLocation) {
        Manifest m = this.loadManifest(bundleLocation);
        if (m == null) {
            return null;
        }
        Properties manifest = this.manifestToProperties(m.getMainAttributes());
        if (((Dictionary)manifest).get("Bundle-SymbolicName") == null) {
            return null;
        }
        if (((Dictionary)manifest).get("Bundle-ClassPath") == null) {
            ((Dictionary)manifest).put("Bundle-ClassPath", ".");
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Manifest loadManifest(File bundleLocation) {
        try {
            block15: {
                if (bundleLocation.isDirectory()) {
                    File m = new File(bundleLocation, "META-INF/MANIFEST.MF");
                    if (m.canRead()) {
                        return this.loadManifestFile(m);
                    }
                    m = this.convertPluginManifest(bundleLocation);
                    if (m == null) return null;
                    if (!m.canRead()) return null;
                    return this.loadManifestFile(m);
                }
                if (!bundleLocation.canRead()) {
                    return null;
                }
                if (!bundleLocation.getName().toLowerCase().endsWith(".jar")) {
                    return this.loadManifestFile(bundleLocation);
                }
                ZipFile jar = new ZipFile(bundleLocation, 1);
                try {
                    ZipEntry me = jar.getEntry("META-INF/MANIFEST.MF");
                    if (me == null) break block15;
                    InputStream is = jar.getInputStream(me);
                    try {
                        Manifest mf = new Manifest(is);
                        if (mf.getMainAttributes().getValue("Bundle-ManifestVersion") != null) {
                            Manifest manifest = mf;
                            return manifest;
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    jar.close();
                }
            }
            File m = this.convertPluginManifest(bundleLocation);
            if (m == null) return null;
            if (!m.canRead()) return null;
            return this.loadManifestFile(m);
        }
        catch (IOException e) {
            this.getLogger().warn("Exception reading bundle manifest", (Throwable)e);
            return null;
        }
        catch (PluginConversionException e) {
            this.getLogger().warn("Exception reading bundle manifest", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest loadManifestFile(File m) throws IOException {
        if (!m.canRead()) {
            return null;
        }
        FileInputStream is = new FileInputStream(m);
        try {
            Manifest manifest = new Manifest(is);
            return manifest;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private File convertPluginManifest(File bundleLocation) throws PluginConversionException {
        PluginConverterImpl converter = new PluginConverterImpl(null, null);
        String name = bundleLocation.getName();
        if (name.endsWith(".jar")) {
            name = name.substring(0, name.length() - 4);
        }
        File manifestFile = new File(this.outputDir, name + "/META-INF/MANIFEST.MF");
        manifestFile.getParentFile().mkdirs();
        converter.convertManifest(bundleLocation, manifestFile, false, "3.2", true, null);
        if (manifestFile.exists()) {
            return manifestFile;
        }
        return null;
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    private String fillPatchData(Dictionary manifest) {
        if (manifest.get("Eclipse-ExtensibleAPI") != null) {
            return "Eclipse-ExtensibleAPI: true";
        }
        if (manifest.get("Eclipse-PatchFragment") != null) {
            return "Eclipse-PatchFragment: true";
        }
        return null;
    }

    private BundleDescription addBundle(Dictionary enhancedManifest, File bundleLocation, boolean override) throws BundleException {
        BundleDescription[] conflicts;
        BundleDescription descriptor = this.factory.createBundleDescription(this.state, enhancedManifest, bundleLocation.getAbsolutePath(), this.getNextId());
        String patchValue = this.fillPatchData(enhancedManifest);
        if (patchValue != null) {
            this.patchBundles.put(new Long(descriptor.getBundleId()), patchValue);
        }
        OsgiStateController.setUserProperty(descriptor, PROP_MANIFEST, enhancedManifest);
        if (override && (conflicts = this.state.getBundles(descriptor.getSymbolicName())) != null) {
            for (BundleDescription conflict : conflicts) {
                this.state.removeBundle(conflict);
                this.getLogger().warn(conflict.toString() + " has been replaced by another bundle with the same symbolic name " + descriptor.toString());
            }
        }
        this.state.addBundle(descriptor);
        return descriptor;
    }

    @Override
    public StateHelper getStateHelper() {
        return this.state.getStateHelper();
    }

    @Override
    public Map getPatchData() {
        return this.patchBundles;
    }

    public BundleDescription getResolvedBundle(String bundleId) {
        BundleDescription[] description = this.state.getBundles(bundleId);
        if (description == null) {
            return null;
        }
        for (int i = 0; i < description.length; ++i) {
            if (!description[i].isResolved()) continue;
            return description[i];
        }
        return null;
    }

    @Override
    public void resolveState() {
        if (this.platformProperties != null) {
            this.state.setPlatformProperties((Dictionary)this.platformProperties);
        }
        this.state.resolve(false);
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Resolved OSGi state\n");
            for (BundleDescription bundle : this.state.getBundles()) {
                if (!bundle.isResolved()) {
                    sb.append("NOT ");
                }
                sb.append("RESOLVED ");
                sb.append(bundle.toString()).append(" : ").append(bundle.getLocation());
                sb.append('\n');
                for (ResolverError error : this.state.getResolverErrors(bundle)) {
                    sb.append('\t').append(error.toString()).append('\n');
                }
            }
            this.getLogger().debug(sb.toString());
        }
    }

    public State getState() {
        return this.state;
    }

    @Override
    public BundleDescription[] getBundles() {
        return this.state.getBundles();
    }

    @Override
    public ResolverError[] getResolverErrors(BundleDescription bundle) {
        LinkedHashSet<ResolverError> errors = new LinkedHashSet<ResolverError>();
        this.getRelevantErrors(errors, bundle);
        return errors.toArray(new ResolverError[errors.size()]);
    }

    private void getRelevantErrors(Set<ResolverError> errors, BundleDescription bundle) {
        ResolverError[] bundleErrors = this.state.getResolverErrors(bundle);
        for (int j = 0; j < bundleErrors.length; ++j) {
            ResolverError error = bundleErrors[j];
            errors.add(error);
            VersionConstraint constraint = error.getUnsatisfiedConstraint();
            if (!(constraint instanceof BundleSpecification) && !(constraint instanceof HostSpecification)) continue;
            BundleDescription[] requiredBundles = this.state.getBundles(constraint.getName());
            for (int i = 0; i < requiredBundles.length; ++i) {
                this.getRelevantErrors(errors, requiredBundles[i]);
            }
        }
    }

    public ResolverError[] getAllErrors() {
        BundleDescription[] bundles = this.state.getBundles();
        LinkedHashSet<ResolverError> errors = new LinkedHashSet<ResolverError>();
        for (int i = 0; i < bundles.length; ++i) {
            BundleDescription bundle = bundles[i];
            ResolverError[] bundleErrors = this.state.getResolverErrors(bundle);
            if (bundleErrors == null) continue;
            errors.addAll(Arrays.asList(bundleErrors));
        }
        return errors.toArray(new ResolverError[errors.size()]);
    }

    @Override
    public BundleDescription[] getDependencies(BundleDescription desc) {
        LinkedHashSet<Long> bundleIds = new LinkedHashSet<Long>();
        OsgiStateController.addBundleAndDependencies(desc, bundleIds, true);
        ArrayList<BundleDescription> dependencies = new ArrayList<BundleDescription>();
        Iterator i$ = bundleIds.iterator();
        while (i$.hasNext()) {
            BundleDescription dependency;
            BundleDescription supplier;
            HostSpecification host;
            long bundleId = (Long)i$.next();
            if (desc.getBundleId() == bundleId || (host = (supplier = (dependency = this.state.getBundle(bundleId)).getSupplier().getSupplier()).getHost()) != null && desc.equals(host.getSupplier())) continue;
            dependencies.add(dependency);
        }
        return dependencies.toArray(new BundleDescription[dependencies.size()]);
    }

    private static void addBundleAndDependencies(BundleDescription desc, Set<Long> bundleIds, boolean includeOptional) {
        if (desc != null && bundleIds.add(new Long(desc.getBundleId()))) {
            BundleSpecification[] required = desc.getRequiredBundles();
            for (int i = 0; i < required.length; ++i) {
                if (!includeOptional && required[i].isOptional()) continue;
                OsgiStateController.addBundleAndDependencies((BundleDescription)required[i].getSupplier(), bundleIds, includeOptional);
            }
            ImportPackageSpecification[] importedPkgs = desc.getImportPackages();
            for (int i = 0; i < importedPkgs.length; ++i) {
                ExportPackageDescription exporter = (ExportPackageDescription)importedPkgs[i].getSupplier();
                if (exporter == null || !includeOptional && "optional".equals(importedPkgs[i].getDirective("resolution"))) continue;
                OsgiStateController.addBundleAndDependencies(exporter.getExporter(), bundleIds, includeOptional);
            }
            BundleDescription[] fragments = desc.getFragments();
            for (int i = 0; i < fragments.length; ++i) {
                String id;
                if (!fragments[i].isResolved() || "org.eclipse.ui.workbench.compatibility".equals(id = fragments[i].getSymbolicName())) continue;
                OsgiStateController.addBundleAndDependencies(fragments[i], bundleIds, includeOptional);
            }
            HostSpecification host = desc.getHost();
            if (host != null) {
                OsgiStateController.addBundleAndDependencies((BundleDescription)host.getSupplier(), bundleIds, includeOptional);
            }
        }
    }

    @Override
    public BundleDescription getBundleDescription(MavenProject project) {
        String location = project.getFile().getParentFile().getAbsolutePath();
        return this.state.getBundleByLocation(location);
    }

    @Override
    public BundleDescription getBundleDescription(File location) {
        String absolutePath = location.getAbsolutePath();
        return this.state.getBundleByLocation(absolutePath);
    }

    @Override
    public void addProject(MavenProject project) throws BundleException {
        File basedir = project.getBasedir();
        if ("eclipse-plugin".equals(project.getPackaging()) || "eclipse-test-plugin".equals(project.getPackaging())) {
            File mf = new File(basedir, "META-INF/MANIFEST.MF");
            if (mf.canRead()) {
                BundleDescription desc = this.addBundle(mf, basedir, true);
                String groupId = this.getManifestAttribute(desc, "MavenArtifact-GroupId");
                if (groupId != null && !groupId.equals(project.getGroupId())) {
                    throw new BundleException("groupId speicified in bundle manifest does not match pom.xml");
                }
                OsgiStateController.setUserProperty(desc, PROP_MAVEN_PROJECT, project);
            }
        } else if ("eclipse-feature".equals(project.getPackaging())) {
            try {
                Feature feature = Feature.read(new File(basedir, "feature.xml"));
                feature.setUserProperty(PROP_MAVEN_PROJECT, project);
                String location = project.getFile().getParentFile().getAbsolutePath();
                this.features.put(location, feature);
            }
            catch (Exception e) {
                throw new BundleException("Exception reading eclipse feature", (Throwable)e);
            }
        }
    }

    private static void setUserProperty(BundleDescription desc, String name, Object value) throws BundleException {
        Object userObject = desc.getUserObject();
        if (userObject != null && !(userObject instanceof Map)) {
            throw new BundleException("Unexpected user object " + desc.toString());
        }
        HashMap<String, Object> props = (HashMap<String, Object>)userObject;
        if (props == null) {
            props = new HashMap<String, Object>();
            desc.setUserObject(props);
        }
        props.put(name, value);
    }

    private static Object getUserProperty(BundleDescription desc, String name) {
        Object userObject = desc.getUserObject();
        if (userObject instanceof Map) {
            return ((Map)userObject).get(name);
        }
        return null;
    }

    @Override
    public MavenProject getMavenProject(BundleDescription desc) {
        return (MavenProject)OsgiStateController.getUserProperty(desc, PROP_MAVEN_PROJECT);
    }

    @Override
    public String getGroupId(BundleDescription desc) {
        MavenProject mavenProject = this.getMavenProject(desc);
        if (mavenProject != null) {
            return mavenProject.getGroupId();
        }
        return this.getManifestAttribute(desc, "MavenArtifact-GroupId");
    }

    @Override
    public void init(File targetPlatform, File workspace, Properties props) {
        boolean forceP2 = targetPlatform != null;
        this.state = this.factory.createState(true);
        this.features = new LinkedHashMap<String, Feature>();
        this.platformProperties = new Properties(props);
        this.platformProperties.put("osgi.os", PlatformPropertiesUtils.getOS(this.platformProperties));
        this.platformProperties.put("osgi.ws", PlatformPropertiesUtils.getWS(this.platformProperties));
        this.platformProperties.put("osgi.arch", PlatformPropertiesUtils.getArch(this.platformProperties));
        ExecutionEnvironmentUtils.loadVMProfile(this.platformProperties);
        String property = props.getProperty("tycho.targetPlatform");
        if (property != null) {
            targetPlatform = new File(property);
        }
        if (targetPlatform == null) {
            this.getLogger().warn("Eclipse target platform is empty");
            return;
        }
        this.targetPlatform = targetPlatform;
        if (workspace != null) {
            try {
                this.outputDir = new File(workspace, "TYCHO").getCanonicalFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.outputDir == null) {
            try {
                this.outputDir = File.createTempFile("TYCHO", null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.outputDir.mkdirs();
        this.loadTargetPlatform(targetPlatform, forceP2);
    }

    @Override
    public BundleDescription getBundleDescription(String symbolicName, String version) {
        try {
            if ("highest version" == version) {
                return this.getBundleDescription(symbolicName);
            }
            return this.state.getBundle(symbolicName, new Version(version));
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private BundleDescription getBundleDescription(String symbolicName) {
        BundleDescription[] bundles = this.state.getBundles(symbolicName);
        BundleDescription highest = null;
        if (bundles != null) {
            for (BundleDescription desc : bundles) {
                if (highest != null && highest.getVersion().compareTo((Object)desc.getVersion()) >= 0) continue;
                highest = desc;
            }
        }
        return highest;
    }

    @Override
    public void assertResolved(BundleDescription desc) throws BundleException {
        if (!desc.isResolved()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Bundle ").append(desc.getSymbolicName()).append(" cannot be resolved\n");
            msg.append("Resolution errors:\n");
            ResolverError[] errors = this.getResolverErrors(desc);
            for (int i = 0; i < errors.length; ++i) {
                ResolverError error = errors[i];
                msg.append("   Bundle ").append(error.getBundle().getSymbolicName()).append(" - ").append(error.toString()).append("\n");
            }
            throw new BundleException(msg.toString());
        }
    }

    @Override
    public String getManifestAttribute(BundleDescription desc, String attr) {
        Dictionary mf = (Dictionary)OsgiStateController.getUserProperty(desc, PROP_MANIFEST);
        if (mf != null) {
            return (String)mf.get(attr);
        }
        return null;
    }

    @Override
    public File getTargetPlaform() {
        return this.targetPlatform;
    }

    @Override
    public Feature getFeature(String id, String version) {
        for (Feature feature : this.features.values()) {
            if (!id.equals(feature.getId())) continue;
            return feature;
        }
        return null;
    }

    @Override
    public MavenProject getMavenProject(Feature feature) {
        return (MavenProject)feature.getUserProperty(PROP_MAVEN_PROJECT);
    }

    @Override
    public Feature getFeature(MavenProject project) {
        String location = project.getFile().getParentFile().getAbsolutePath();
        return this.features.get(location);
    }
}

