/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.osgitools.AbstractDependenciesReader;
import org.codehaus.tycho.osgitools.OsgiState;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureDependencyReader
extends AbstractDependenciesReader {
    private OsgiState state;

    @Override
    public List<Dependency> getDependencies(MavenProject project) throws MavenExecutionException {
        Dependency dependency;
        Feature feature = this.state.getFeature(project);
        if (feature == null) {
            return NO_DEPENDENCIES;
        }
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Feature.PluginRef pluginRef : feature.getPlugins()) {
            BundleDescription bundle = this.state.getBundleDescription(pluginRef.getId(), this.getPluginVersion(pluginRef.getVersion()));
            if (bundle == null || (dependency = this.newProjectDependency(this.state.getMavenProject(bundle))) == null) continue;
            result.add(dependency);
        }
        for (Feature.FeatureRef featureRef : feature.getIncludedFeatures()) {
            Feature otherFeature = this.state.getFeature(featureRef.getId(), featureRef.getVersion());
            if (otherFeature == null || (dependency = this.newProjectDependency(this.state.getMavenProject(otherFeature))) == null) continue;
            result.add(dependency);
        }
        return result;
    }

    private String getPluginVersion(String version) {
        return "0.0.0".equals(version) ? "highest version" : version;
    }
}

