/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.plugin.pom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SynchronizeFeaturePomMojo
extends AbstractMojo {
    protected List remoteRepositories;
    private File featureFile;
    private File pomFile;
    private String groupId;
    private String version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Model model = this.readPom(this.pomFile);
            Iterator it = model.getDependencies().iterator();
            while (it.hasNext()) {
                String scope = ((Dependency)it.next()).getScope();
                if (scope != null && !scope.equals(DefaultArtifact.SCOPE_COMPILE)) continue;
                it.remove();
            }
            Dependency[] dependencies = this.getPluginIDs(this.featureFile);
            this.getLog().info((CharSequence)"Dependent bundles:");
            for (int i = 0; i < dependencies.length; ++i) {
                Dependency d = dependencies[i];
                model.getDependencies().add(d);
                this.getLog().info((CharSequence)(this.groupId + ":" + d.getArtifactId() + ":" + this.version));
            }
            new MavenXpp3Writer().write((Writer)new FileWriter(this.pomFile), model);
        }
        catch (IOException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("", (Exception)((Object)e));
        }
    }

    private Model readPom(File pom) throws IOException, XmlPullParserException {
        return new MavenXpp3Reader().read((Reader)new FileReader(pom));
    }

    private Dependency[] getPluginIDs(File pomFile) throws MojoExecutionException {
        try {
            XPath path = XPathFactory.newInstance().newXPath();
            NodeList l1 = (NodeList)path.evaluate("/feature/plugin", new InputSource(new FileInputStream(this.featureFile)), XPathConstants.NODESET);
            ArrayList<Dependency> result = new ArrayList<Dependency>();
            for (int i = 0; i < l1.getLength(); ++i) {
                Node node = l1.item(i);
                String version = node.getAttributes().getNamedItem("version").getTextContent();
                String id = node.getAttributes().getNamedItem("id").getTextContent();
                Dependency d = new Dependency();
                d.setGroupId(this.groupId);
                d.setVersion(version);
                d.setArtifactId(id);
                result.add(d);
            }
            return result.toArray(new Dependency[result.size()]);
        }
        catch (XPathExpressionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }
}

