/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.plugin.artifactfilter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.tycho.plugin.artifactfilter.ArtifactsFilter;

public class TypeFilter
implements ArtifactsFilter {
    private List includeTypes;
    private List excludeTypes;
    private String includeString;
    private String excludeString;

    public TypeFilter(String include, String exclude) {
        this.setExcludeTypes(exclude);
        this.setIncludeTypes(include);
    }

    public Set filter(Set artifacts, Log log) {
        Set results = artifacts;
        if (this.includeTypes != null && !this.includeTypes.isEmpty()) {
            log.debug((CharSequence)("Including only Types: " + this.includeString));
            results = this.filterIncludes(artifacts, this.includeTypes);
        } else if (this.excludeTypes != null && !this.excludeTypes.isEmpty()) {
            log.debug((CharSequence)("Excluding Types: " + this.excludeString));
            results = this.filterExcludes(artifacts, this.excludeTypes);
        }
        return results;
    }

    private Set filterIncludes(Set artifacts, List types) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (String artifactType : types) {
            for (Artifact artifact : artifacts) {
                if (!artifact.getType().equals(artifactType)) continue;
                result.add(artifact);
            }
        }
        return result;
    }

    private Set filterExcludes(Set artifacts, List types) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            boolean exclude = false;
            Artifact artifact = (Artifact)iter.next();
            for (String artifactType : types) {
                if (!artifact.getType().equals(artifactType)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            result.add(artifact);
        }
        return result;
    }

    public void setExcludeTypes(String excludeTypeString) {
        this.excludeString = excludeTypeString;
        if (StringUtils.isNotEmpty((String)excludeTypeString)) {
            this.excludeTypes = Arrays.asList(StringUtils.split((String)excludeTypeString, (String)","));
        }
    }

    public void setIncludeTypes(String includeTypeString) {
        this.includeString = includeTypeString;
        if (StringUtils.isNotEmpty((String)includeTypeString)) {
            this.includeTypes = Arrays.asList(StringUtils.split((String)includeTypeString, (String)","));
        }
    }

    public List getExcludeTypes() {
        return this.excludeTypes;
    }

    public List getIncludeTypes() {
        return this.includeTypes;
    }
}

