/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.tycho.model.Platform;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.OsgiStateController;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelper {
    private final OsgiState state;
    private static final Map<String, Integer> START_LEVEL = new HashMap<String, Integer>();

    ConfigurationHelper(OsgiState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConfiguration(File work, File targetPlatform, Set<File> testBundles) throws MojoExecutionException {
        try {
            String newOsgiBundles;
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(new File(targetPlatform, "configuration/config.ini"));
            try {
                p.load(fis);
            }
            finally {
                fis.close();
            }
            if (this.shouldUseP2()) {
                this.createBundlesInfoFile(work);
                this.createPlatformXmlFile(work);
                newOsgiBundles = "org.eclipse.equinox.simpleconfigurator@1:start";
            } else if (this.shouldUseUpdateManager()) {
                this.createPlatformXmlFile(work);
                newOsgiBundles = "org.eclipse.equinox.common@2:start, org.eclipse.update.configurator@3:start, org.eclipse.core.runtime@start";
            } else {
                newOsgiBundles = this.toOsgiBundles(this.state.getBundles());
            }
            p.setProperty("osgi.bundles", newOsgiBundles);
            p.setProperty("osgi.bundlefile.limit", "100");
            ConfigurationHelper.addRequiredProperties(p, targetPlatform);
            String url = p.getProperty("osgi.framework");
            if (url != null) {
                BundleDescription desc = this.state.getBundleDescription(url, "highest version");
                if (desc != null) {
                    url = "file:" + new File(desc.getLocation()).getAbsolutePath().replace('\\', '/');
                } else if (url.startsWith("file:")) {
                    String path = url.substring("file:".length());
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(targetPlatform, path);
                    }
                    url = "file:" + file.getAbsolutePath().replace('\\', '/');
                }
            }
            if (url != null) {
                p.setProperty("osgi.framework", url);
            }
            new File(work, "configuration").mkdir();
            FileOutputStream fos = new FileOutputStream(new File(work, "configuration/config.ini"));
            try {
                p.store(fos, null);
            }
            finally {
                fos.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception creating config.ini", (Exception)e);
        }
    }

    private void createPlatformXmlFile(File work) throws IOException {
        Platform platform = this.state.getPlatform();
        Platform.write((Platform)platform, (File)new File(work, "configuration/org.eclipse.update/platform.xml"));
    }

    private void createBundlesInfoFile(File work) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (BundleDescription bundle : this.state.getBundles()) {
            File location = ((OsgiStateController)this.state).getBundleLocation(bundle);
            Manifest manifest = this.state.loadManifest(location);
            Attributes attributes = manifest.getMainAttributes();
            String version = attributes.getValue("Bundle-Version");
            sb.append(bundle.getSymbolicName()).append(',');
            sb.append(version).append(',');
            sb.append(location.toURL().toExternalForm()).append(',');
            Integer level = START_LEVEL.get(bundle.getSymbolicName());
            if (level != null) {
                sb.append(level).append(',');
                sb.append("true");
            } else {
                sb.append("4").append(',');
                sb.append("false");
            }
            sb.append('\n');
        }
        ConfigurationHelper.fileWrite(new File(work, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info"), sb.toString());
    }

    private static void fileWrite(File file, String data) throws IOException {
        file.getParentFile().mkdirs();
        FileUtils.fileWrite((String)file.getAbsolutePath(), (String)data);
    }

    private boolean shouldUseUpdateManager() {
        return this.state.getBundleDescription("org.eclipse.update.configurator", "highest version") != null;
    }

    private boolean shouldUseP2() {
        return this.state.getBundleDescription("org.eclipse.equinox.simpleconfigurator", "highest version") != null;
    }

    private String toOsgiBundles(BundleDescription[] bundles) throws IOException {
        StringBuilder result = new StringBuilder();
        for (BundleDescription bundle : bundles) {
            Integer level = START_LEVEL.get(bundle.getSymbolicName());
            if (level != null && level == -1) continue;
            if (result.length() > 0) {
                result.append(",");
            }
            File file = new File(bundle.getLocation());
            result.append(this.appendAbsolutePath(file));
            if (level == null) continue;
            result.append('@').append(level).append(":start");
        }
        return result.toString();
    }

    private String appendAbsolutePath(File file) throws IOException {
        String url = file.getAbsolutePath().replace('\\', '/');
        return "reference:file:" + url;
    }

    private static void addRequiredProperties(Properties properties, File targetPlatform) {
        if (!properties.containsKey("osgi.install.area")) {
            properties.setProperty("osgi.install.area", "file:" + targetPlatform.getAbsolutePath().replace('\\', '/'));
        }
        properties.setProperty("osgi.configuration.cascaded", "false");
        if (!properties.containsKey("osgi.framework")) {
            properties.setProperty("osgi.framework", "org.eclipse.osgi");
        }
        if (!properties.containsKey("osgi.bundles.defaultStartLevel")) {
            properties.setProperty("osgi.bundles.defaultStartLevel", "4");
        }
    }

    static {
        START_LEVEL.put("org.eclipse.equinox.common", 2);
        START_LEVEL.put("org.eclipse.core.runtime", 4);
        START_LEVEL.put("org.eclipse.equinox.simpleconfigurator", 1);
        START_LEVEL.put("org.eclipse.update.configurator", 3);
        START_LEVEL.put("org.eclipse.osgi", -1);
    }
}

