/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.source.AbstractSourceJarMojo;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiSourceMojo
extends AbstractSourceJarMojo {
    private boolean usePdeSourceRoots;

    protected List<String> getSources(MavenProject p) throws MojoExecutionException {
        if (this.usePdeSourceRoots) {
            Properties props = this.getBuildProperties();
            if (props.containsKey("source..")) {
                String sourceRaw = props.getProperty("source..");
                ArrayList<String> sources = new ArrayList<String>();
                for (String source : sourceRaw.split(",")) {
                    sources.add(new File(this.project.getBasedir(), source).getAbsolutePath());
                }
                return sources;
            }
            throw new MojoExecutionException("Source folder not found at build.properties");
        }
        return p.getCompileSourceRoots();
    }

    protected List getResources(MavenProject p) {
        if (this.excludeResources) {
            return Collections.EMPTY_LIST;
        }
        if (this.usePdeSourceRoots) {
            return Collections.EMPTY_LIST;
        }
        return p.getResources();
    }

    protected String getClassifier() {
        return "sources";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getBuildProperties() throws MojoExecutionException {
        File file = new File(this.project.getBasedir(), "build.properties");
        if (!file.canRead()) {
            throw new MojoExecutionException("Unable to read build.properties file");
        }
        Properties buildProperties = new Properties();
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                buildProperties.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception reading build.properties file", (Exception)e);
        }
        return buildProperties;
    }
}

