/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.tycho.eclipsepackaging.Util;
import org.codehaus.tycho.eclipsepackaging.VersionExpander;
import org.codehaus.tycho.osgitools.OsgiState;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

public class PackagePluginMojo
extends AbstractMojo {
    private static final String OUTPUT = "output.";
    private static final String SOURCE = "source.";
    protected File buildDirectory;
    protected File outputDirectory;
    protected MavenProject project;
    private JarArchiver jarArchiver = new JarArchiver();
    protected String finalName;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected MavenProjectHelper projectHelper;
    protected String qualifier;
    protected OsgiState state;
    private VersionExpander versionExpander = new VersionExpander();
    private Properties buildProperties;

    public void execute() throws MojoExecutionException {
        this.createPlugin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlugin() throws MojoExecutionException {
        try {
            this.buildProperties = new Properties();
            File file = new File(this.project.getBasedir(), "build.properties");
            if (file.canRead()) {
                FileInputStream is = new FileInputStream(file);
                try {
                    this.buildProperties.load(is);
                }
                finally {
                    is.close();
                }
            }
            this.createSubJars();
            File pluginFile = this.createPluginJar();
            this.project.getArtifact().setFile(pluginFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private void createSubJars() throws MojoExecutionException {
        try {
            for (String string : this.buildProperties.keySet()) {
                String[] classesDir;
                String fileName;
                if (string.startsWith(OUTPUT) && !string.equals("output..")) {
                    fileName = string.substring(OUTPUT.length());
                    classesDir = this.buildProperties.getProperty(string).split(",");
                    this.makeJar(fileName, classesDir);
                    continue;
                }
                if (!string.startsWith(SOURCE) || string.equals("source..")) continue;
                fileName = string.substring(SOURCE.length());
                classesDir = new String[]{this.buildDirectory.getName() + "/" + fileName.substring(0, fileName.length() - 4) + "-classes"};
                this.makeJar(fileName, classesDir);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    private File makeJar(String fileName, String[] classesDir) throws MojoExecutionException {
        File jarFile = new File(this.project.getBasedir(), fileName);
        Util.makeJar(this.project.getBasedir(), jarFile, classesDir, new JarArchiver(), null);
        return jarFile;
    }

    private File createPluginJar() throws MojoExecutionException {
        try {
            File manifest;
            String output;
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            File pluginFile = new File(this.buildDirectory, this.finalName + ".jar");
            if (pluginFile.exists()) {
                pluginFile.delete();
            }
            if ((output = this.buildProperties.getProperty("output..")) != null) {
                String[] includes = output.split(",");
                this.addToArchiver(archiver, includes, false);
            }
            if (this.outputDirectory.exists()) {
                archiver.getArchiver().addDirectory(this.outputDirectory);
            }
            if (this.buildProperties.containsKey("bin.includes")) {
                String[] binIncludes = this.buildProperties.getProperty("bin.includes").split(",");
                this.addToArchiver(archiver, binIncludes, true);
            }
            if ((manifest = this.updateManifest()).exists()) {
                this.archive.setManifestFile(manifest);
            }
            archiver.setOutputFile(pluginFile);
            archiver.createArchive(this.project, this.archive);
            return pluginFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File updateManifest() throws FileNotFoundException, IOException, MojoExecutionException {
        Manifest mf;
        BundleDescription bundle = this.state.getBundleDescription(this.project);
        Version version = bundle.getVersion();
        this.versionExpander.validateVersion(this.project, version);
        File mfile = new File(this.project.getBasedir(), "META-INF/MANIFEST.MF");
        FileInputStream is = new FileInputStream(mfile);
        try {
            mf = new Manifest(is);
        }
        finally {
            ((InputStream)is).close();
        }
        Attributes attributes = mf.getMainAttributes();
        if (this.versionExpander.isSnapshotVersion(version)) {
            Version expandedVersion = this.versionExpander.expandVersion(version, this.qualifier);
            attributes.putValue("Bundle-Version", expandedVersion.toString());
            this.state.setFinalVersion(bundle, expandedVersion);
        }
        attributes.putValue("MavenArtifact-GroupId", this.project.getGroupId());
        attributes.putValue("MavenArtifact-BaseVersion", this.project.getVersion());
        mfile = new File(this.project.getBuild().getDirectory(), "MANIFEST.MF");
        mfile.getParentFile().mkdirs();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mfile));
        try {
            mf.write(os);
        }
        finally {
            os.close();
        }
        return mfile;
    }

    private void addToArchiver(MavenArchiver archiver, String[] includes, boolean includeBase) throws ArchiverException {
        for (int i = 0; i < includes.length; ++i) {
            File f;
            String file = includes[i];
            if (file.equals(".") || !(f = new File(this.project.getBasedir(), file)).exists()) continue;
            if (f.isDirectory()) {
                archiver.getArchiver().addDirectory(f, includeBase ? file : "", Util.DEFAULT_INCLUDES, Util.DEFAULT_EXCLUDES);
                continue;
            }
            archiver.getArchiver().addFile(f, file);
        }
    }
}

