/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.tycho.eclipsepackaging.product.Feature;
import org.codehaus.tycho.eclipsepackaging.product.Plugin;
import org.codehaus.tycho.eclipsepackaging.product.ProductConfiguration;
import org.codehaus.tycho.eclipsepackaging.product.ProductConfigurationConverter;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductExportMojo
extends AbstractMojo
implements Contextualizable {
    private PlexusContainer plexus;
    private OsgiState state;
    protected MavenProject project;
    private File target;
    private File productConfigurationFile;
    private ProductConfiguration productConfiguration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File basedir;
        File productCfg;
        if (this.productConfigurationFile == null && (productCfg = new File(basedir = this.project.getBasedir(), this.project.getArtifactId() + ".product")).exists()) {
            this.productConfigurationFile = productCfg;
        }
        if (this.productConfigurationFile == null) {
            throw new MojoExecutionException("Product configuration file not expecified");
        }
        if (!this.productConfigurationFile.exists()) {
            throw new MojoExecutionException("Product configuration file not found " + this.productConfigurationFile.getAbsolutePath());
        }
        XStream xs = new XStream();
        xs.registerConverter((Converter)new ProductConfigurationConverter(this.getLog()));
        xs.processAnnotations(ProductConfiguration.class);
        try {
            this.getLog().debug((CharSequence)"Parsing productConfiguration");
            this.productConfiguration = (ProductConfiguration)xs.fromXML((InputStream)new FileInputStream(this.productConfigurationFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading product configuration file", (Exception)e);
        }
        catch (XStreamException e) {
            throw new MojoExecutionException("Error parsing product configuration file", (Exception)((Object)e));
        }
        this.addOsgiLauncherPlugins();
        this.generateEclipseProduct();
        this.generateConfigIni();
        if (this.productConfiguration.getUseFeatures().booleanValue()) {
            this.copyFeatures(this.productConfiguration.getFeatures());
        } else {
            this.copyPlugins(this.productConfiguration.getPlugins());
        }
        this.copyExecutable();
    }

    private void addOsgiLauncherPlugins() {
        String ws = this.state.getPlatformProperty("osgi.ws");
        String os = this.state.getPlatformProperty("osgi.os");
        String arch = this.state.getPlatformProperty("osgi.arch");
        this.productConfiguration.getPlugins().add(new Plugin("org.eclipse.equinox.launcher", null));
        this.productConfiguration.getPlugins().add(new Plugin("org.eclipse.equinox.launcher." + ws + "." + os + "." + arch, null));
    }

    private void generateEclipseProduct() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating .eclipseproduct");
        Properties props = new Properties();
        this.setPropertyIfNotNull(props, "version", this.productConfiguration.getVersion());
        this.setPropertyIfNotNull(props, "name", this.productConfiguration.getName());
        this.setPropertyIfNotNull(props, "id", this.productConfiguration.getId());
        this.target.mkdirs();
        File eclipseproduct = new File(this.target, ".eclipseproduct");
        try {
            FileOutputStream fos = new FileOutputStream(eclipseproduct);
            props.store(fos, "Eclipse Product File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private void generateConfigIni() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating config.ini");
        Properties props = new Properties();
        this.setPropertyIfNotNull(props, "osgi.splashPath", "platform:/base/plugins/" + this.productConfiguration.getPlugins().get(0).getId());
        this.setPropertyIfNotNull(props, "eclipse.product", this.productConfiguration.getId());
        this.setPropertyIfNotNull(props, "osgi.bundles.defaultStartLevel", "4");
        if (this.productConfiguration.getUseFeatures().booleanValue()) {
            this.setPropertyIfNotNull(props, "osgi.bundles", this.getFeaturesOsgiBundles());
        } else {
            this.setPropertyIfNotNull(props, "osgi.bundles", this.getPluginsOsgiBundles());
        }
        File configsFolder = new File(this.target, "configuration");
        configsFolder.mkdirs();
        File configIni = new File(configsFolder, "config.ini");
        try {
            FileOutputStream fos = new FileOutputStream(configIni);
            props.store(fos, "Product Runtime Configuration File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private String getFeaturesOsgiBundles() {
        return "org.eclipse.equinox.common@2:start,org.eclipse.update.configurator@3:start,org.eclipse.core.runtime@start";
    }

    private String getPluginsOsgiBundles() {
        List<Plugin> plugins = this.productConfiguration.getPlugins();
        StringBuilder buf = new StringBuilder(plugins.size() * 10);
        for (Plugin plugin : plugins) {
            if (buf.length() != 0) {
                buf.append(',');
            }
            if ("org.eclipse.osgi".equals(plugin.getId())) continue;
            buf.append(plugin.getId());
            if (!"org.eclipse.core.runtime".equals(plugin.getId())) continue;
            buf.append("@start");
        }
        return buf.toString();
    }

    private void copyFeatures(List<Feature> features) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("copying " + features.size() + " features "));
        File featuresFolder = new File(this.target, "features");
        featuresFolder.mkdirs();
        LinkedHashSet<Plugin> plugins = new LinkedHashSet<Plugin>();
        for (Feature feature : features) {
            plugins.addAll(this.copyFeature(feature, featuresFolder));
        }
        this.copyPlugins(plugins);
    }

    private List<Plugin> copyFeature(Feature feature, File featuresFolder) throws MojoExecutionException {
        File source;
        org.codehaus.tycho.model.Feature featureRef;
        String featureVersion;
        String featureId = feature.getId();
        FeatureDescription bundle = this.state.getFeatureDescription(featureId, featureVersion = feature.getVersion());
        if (bundle != null) {
            this.getLog().debug((CharSequence)("feature = bundle: " + bundle.getLocation()));
            try {
                featureRef = org.codehaus.tycho.model.Feature.read((File)new File(bundle.getLocation(), "feature.xml"));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error reading feature.xml for " + featureId);
            }
        } else {
            this.getLog().debug((CharSequence)"feature = project");
            featureRef = this.state.getFeature(featureId, featureVersion);
        }
        if (featureRef == null) {
            throw new MojoExecutionException("Unable to resolve feature " + featureId + "_" + featureVersion);
        }
        MavenProject project = this.state.getMavenProject(featureRef);
        if (project != null) {
            ZipUnArchiver unArchiver;
            source = project.getArtifact().getFile();
            try {
                unArchiver = (ZipUnArchiver)this.plexus.lookup(ZipUnArchiver.ROLE, "zip");
            }
            catch (ComponentLookupException e) {
                throw new MojoExecutionException("Unable to resolve ZipUnArchiver", (Exception)((Object)e));
            }
            unArchiver.setDestDirectory(featuresFolder.getParentFile());
            unArchiver.setSourceFile(source);
            FileSelector[] fileSelectors = new FileSelector[]{new FileSelector(){

                public boolean isSelected(FileInfo fileInfo) throws IOException {
                    return fileInfo.getName().startsWith("features");
                }
            }};
            unArchiver.setFileSelectors(fileSelectors);
            try {
                unArchiver.extract();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error extracting feature " + featureId, e);
            }
        }
        source = bundle.getLocation();
        this.copyToDirectory(source, featuresFolder);
        List featureRefs = featureRef.getIncludedFeatures();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        for (Feature.FeatureRef fRef : featureRefs) {
            plugins.addAll(this.copyFeature(new Feature(fRef.getId(), fRef.getVersion()), featuresFolder));
        }
        List pluginRefs = featureRef.getPlugins();
        for (Feature.PluginRef pluginRef : pluginRefs) {
            if (!this.matchCurrentPlataform(pluginRef)) continue;
            plugins.add(new Plugin(pluginRef.getId(), pluginRef.getVersion()));
        }
        return plugins;
    }

    private boolean matchCurrentPlataform(Feature.PluginRef pluginRef) {
        String ws = this.state.getPlatformProperty("osgi.ws");
        String os = this.state.getPlatformProperty("osgi.os");
        String arch = this.state.getPlatformProperty("osgi.arch");
        String pluginWs = pluginRef.getWs();
        String pluginOs = pluginRef.getOs();
        String pluginArch = pluginRef.getArch();
        return !(pluginWs != null && !ws.equals(pluginWs) || pluginOs != null && !os.equals(pluginOs) || pluginArch != null && !arch.equals(pluginArch));
    }

    private void copyPlugins(Collection<Plugin> plugins) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("copying " + plugins.size() + " plugins "));
        File pluginsFolder = new File(this.target, "plugins");
        pluginsFolder.mkdirs();
        for (Plugin plugin : plugins) {
            File source;
            BundleDescription bundle;
            String bundleId = plugin.getId();
            String bundleVersion = plugin.getVersion();
            if (bundleVersion == null || "0.0.0".equals(bundleVersion)) {
                bundleVersion = "highest version";
            }
            if ((bundle = this.state.getBundleDescription(bundleId, bundleVersion)) == null) {
                throw new MojoExecutionException("Plugin " + bundleId + " not found!");
            }
            MavenProject bundleProject = this.state.getMavenProject(bundle);
            if (bundleProject != null) {
                source = bundleProject.getArtifact().getFile();
                File target = new File(pluginsFolder, bundleProject.getArtifactId() + "_" + bundleProject.getVersion() + ".jar");
                this.copyToFile(source, target);
                continue;
            }
            source = new File(bundle.getLocation());
            this.copyToDirectory(source, pluginsFolder);
        }
    }

    private void copyToFile(File source, File target) throws MojoExecutionException {
        try {
            target.getParentFile().mkdirs();
            if (source.isFile()) {
                FileUtils.copyFile((File)source, (File)target);
            } else if (source.isDirectory()) {
                FileUtils.copyDirectory((File)source, (File)target);
            } else {
                this.getLog().warn((CharSequence)("Skipping bundle " + source.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy " + source.getName(), (Exception)e);
        }
    }

    private void copyToDirectory(File source, File targetFolder) throws MojoExecutionException {
        try {
            if (source.isFile()) {
                FileUtils.copyFileToDirectory((File)source, (File)targetFolder);
            } else if (source.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)source, (File)targetFolder);
            } else {
                this.getLog().warn((CharSequence)("Skipping bundle " + source.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy " + source.getName(), (Exception)e);
        }
    }

    private void copyExecutable() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Creating launcher.exe");
        FeatureDescription feature = this.state.getFeatureDescription("org.eclipse.equinox.executable", null);
        if (feature == null) {
            String msg = "RPC delta feature not found!";
            throw new MojoExecutionException(msg, (Exception)new ArtifactResolutionException(msg, "", "org.eclipse.equinox.executable", "", "eclipse-feature", null, null));
        }
        String ws = this.state.getPlatformProperty("osgi.ws");
        String os = this.state.getPlatformProperty("osgi.os");
        String arch = this.state.getPlatformProperty("osgi.arch");
        File location = feature.getLocation();
        File osLauncher = new File(location, "bin/" + ws + "/" + os + "/" + arch);
        try {
            IOFileFilter eclipsecFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"eclipsec"));
            FileUtils.copyDirectory((File)osLauncher, (File)this.target, (FileFilter)eclipsecFilter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy launcher executable", (Exception)e);
        }
        File launcher = this.getLauncher();
        try {
            this.getLog().debug((CharSequence)"running chmod");
            ArchiveEntryUtils.chmod((File)launcher, (int)493, null);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to make launcher being executable", (Exception)((Object)e));
        }
        if (this.productConfiguration.getLauncher() != null && this.productConfiguration.getLauncher().getName() != null) {
            String launcherName = this.productConfiguration.getLauncher().getName();
            this.getLog().debug((CharSequence)("Renaming launcher to " + launcherName));
            String newName = launcherName;
            if ("win32".equals(os)) {
                String extension = FilenameUtils.getExtension((String)launcher.getAbsolutePath());
                newName = launcherName + "." + extension;
            }
            launcher.renameTo(new File(launcher.getParentFile(), newName));
        }
    }

    private File getLauncher() throws MojoExecutionException {
        String os = this.state.getPlatformProperty("osgi.os");
        if ("win32".equals(os)) {
            return new File(this.target, "launcher.exe");
        }
        if ("linux".equals(os) || "solaris".equals(os) || "hpux".equals(os) || "aix".equals(os)) {
            return new File(this.target, "launcher");
        }
        if ("macosx".equals(os)) {
            return new File(this.target, "Eclipse.app/Contents/MacOS/launcher");
        }
        throw new MojoExecutionException("Unexpected OS: " + os);
    }

    private void setPropertyIfNotNull(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    public void contextualize(Context ctx) throws ContextException {
        this.plexus = (PlexusContainer)ctx.get((Object)"plexus");
    }
}

