/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgicompiler;

import java.io.File;
import java.io.FileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.tycho.osgitools.OsgiState;
import org.osgi.framework.BundleException;

public class ApplicationDependencyVerifierMojo
extends AbstractMojo {
    private File pluginDirectory;
    private boolean failOnError;
    private File outputDir;
    private OsgiState state;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] jars = this.pluginDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar") || pathname.isDirectory();
            }
        });
        for (int i = 0; i < jars.length; ++i) {
            File jar = jars[i];
            try {
                this.state.addBundle(jar);
                continue;
            }
            catch (BundleException e) {
                this.getLog().error((CharSequence)("Error adding bundle " + jar));
                throw new MojoExecutionException("Error adding bundle", (Exception)((Object)e));
            }
        }
        this.state.resolveState();
        boolean errorsFound = false;
        if (!errorsFound) {
            this.getLog().info((CharSequence)"Configuration verified: no resolving errors");
        }
        if (errorsFound && this.failOnError) {
            throw new MojoFailureException("Errors found while verifying installation");
        }
    }
}

