/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgicompiler;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.project.MavenProject;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.OsgiStateController;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathComputer3_0 {
    private static final String EXCLUDE_ALL_RULE = "-**/*";
    private static final String error_pluginCycle = "A cycle was detected when generating the classpath {0}.";
    public static final String ACCESS_RULE_SEPARATOR = File.pathSeparator;
    private Map visiblePackages = null;
    private Map<String, ClasspathElement> pathElements = null;
    private final OsgiState state;
    private final BundleDescription theBundle;
    private final File storage;

    public ClasspathComputer3_0(BundleDescription theBundle, OsgiState osgiState, File storage) {
        this.state = osgiState;
        this.theBundle = theBundle;
        this.storage = storage;
    }

    public List<ClasspathElement> getClasspath() {
        ArrayList<ClasspathElement> classpath = new ArrayList<ClasspathElement>(20);
        ArrayList pluginChain = new ArrayList(10);
        HashSet addedPlugins = new HashSet(10);
        this.pathElements = new HashMap<String, ClasspathElement>();
        this.visiblePackages = this.getVisiblePackages(this.theBundle);
        this.addSelf(this.theBundle, classpath, pluginChain, addedPlugins);
        BundleDescription[] dependencies = this.state.getDependencies(this.theBundle);
        for (int i = 0; i < dependencies.length; ++i) {
            this.addPlugin(dependencies[i], classpath);
        }
        return classpath;
    }

    private Map getVisiblePackages(BundleDescription model) {
        HashMap packages = new HashMap(20);
        StateHelper helper = this.state.getStateHelper();
        this.addVisiblePackagesFromState(helper, model, packages);
        if (model.getHost() != null) {
            this.addVisiblePackagesFromState(helper, (BundleDescription)model.getHost().getSupplier(), packages);
        }
        return packages;
    }

    private void addVisiblePackagesFromState(StateHelper helper, BundleDescription model, Map packages) {
        ExportPackageDescription[] exports = helper.getVisiblePackages(model);
        for (int i = 0; i < exports.length; ++i) {
            BundleDescription exporter = exports[i].getExporter();
            if (exporter == null) continue;
            boolean discouraged = helper.getAccessCode(model, exports[i]) == 2;
            String pattern = exports[i].getName().replaceAll("\\.", "/") + "/*";
            String rule = (discouraged ? (char)'~' : '+') + pattern;
            String rules = (String)packages.get(exporter.getSymbolicName());
            if (rules != null) {
                if (rules.indexOf(rule) == -1) {
                    rules = rules != null ? rules + ACCESS_RULE_SEPARATOR + rule : rule;
                }
            } else {
                rules = rule;
            }
            packages.put(exporter.getSymbolicName(), rules);
        }
    }

    private void addPlugin(BundleDescription plugin, List classpath) {
        this.addRuntimeLibraries(plugin, classpath);
    }

    private void addRuntimeLibraries(BundleDescription model, List classpath) {
        String[] libraries = this.getBundleClasspath(model);
        MavenProject project = this.state.getMavenProject(model);
        String base = null;
        File artifact = null;
        if (project != null && project.getArtifact().getFile() != null && (artifact = project.getArtifact().getFile()).isFile() && artifact.canRead()) {
            base = artifact.getAbsolutePath();
        }
        if (base == null) {
            base = model.getLocation();
        }
        for (int i = 0; i < libraries.length; ++i) {
            this.addPathAndCheck(model, base, artifact, libraries[i], classpath);
        }
    }

    private void addPathAndCheck(BundleDescription model, String basePath, File artifact, String libraryName, List classpath) {
        String pluginId = model != null ? model.getSymbolicName() : null;
        String rules = "";
        if (model != null && model != this.theBundle && (this.theBundle.getHost() == null || this.theBundle.getHost().getSupplier() != model)) {
            String packageKey = pluginId;
            if (model.isResolved() && model.getHost() != null) {
                packageKey = ((BundleDescription)model.getHost().getSupplier()).getSymbolicName();
            }
            rules = this.visiblePackages.containsKey(packageKey) ? "[" + (String)this.visiblePackages.get(packageKey) + ACCESS_RULE_SEPARATOR + EXCLUDE_ALL_RULE + "]" : "[-**/*]";
        }
        String path = null;
        try {
            File libraryFile = this.getLibraryFile(model, basePath, artifact, libraryName);
            if (libraryFile != null && libraryFile.exists()) {
                path = libraryFile.getAbsolutePath();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (path != null) {
            this.addClasspathElementWithRule(classpath, path, rules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getLibraryFile(BundleDescription model, String basePath, File artifact, String libraryName) throws IOException {
        File base = new File(basePath);
        if (".".equals(libraryName)) {
            return artifact != null ? artifact : base;
        }
        if (base.isDirectory()) {
            File library = new File(base, libraryName);
            return library;
        }
        JarFile jarFile = new JarFile(base);
        try {
            File target = new File(this.storage, model.getSymbolicName() + "_" + model.getVersion());
            File file = this.extract(jarFile, libraryName, target);
            return file;
        }
        finally {
            jarFile.close();
        }
    }

    public File extract(JarFile jarFile, String element, File tempDirectory) throws IOException {
        int nBytes;
        ZipEntry entry = jarFile.getEntry(element);
        if (entry == null) {
            return null;
        }
        File efile = new File(tempDirectory, entry.getName());
        if (!efile.getParentFile().exists()) {
            efile.getParentFile().mkdirs();
        }
        BufferedInputStream in = new BufferedInputStream(jarFile.getInputStream(entry));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(efile));
        byte[] buffer = new byte[2048];
        while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, nBytes);
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        ((InputStream)in).close();
        return efile;
    }

    private void addClasspathElementWithRule(List classpath, String path, String rules) {
        String normalizedPath = ClasspathElement.normalize(path);
        ClasspathElement existing = this.pathElements.get(normalizedPath);
        if (existing != null) {
            existing.addRules(rules);
        } else {
            ClasspathElement element = new ClasspathElement(normalizedPath, rules);
            classpath.add(element);
            this.pathElements.put(normalizedPath, element);
        }
    }

    private void addSelf(BundleDescription model, List classpath, List pluginChain, Set addedPlugins) {
        HostSpecification host = model.getHost();
        if (host != null) {
            BundleDescription[] hosts = host.getHosts();
            for (int i = 0; i < hosts.length; ++i) {
                this.addPluginAndPrerequisites(hosts[i], classpath, pluginChain, addedPlugins);
            }
        }
        File artifact = new File(this.state.getMavenProject(model).getBuild().getOutputDirectory()).getAbsoluteFile();
        artifact.mkdirs();
        String[] libraries = this.getBundleClasspath(model);
        for (int i = 0; i < libraries.length; ++i) {
            String libraryName = libraries[i];
            this.addPathAndCheck(model, model.getLocation(), artifact, libraryName, classpath);
        }
    }

    private void addPrerequisites(BundleDescription target, List classpath, List pluginChain, Set addedPlugins) {
        if (pluginChain.contains(target)) {
            String cycleString = "";
            Iterator iter = pluginChain.iterator();
            while (iter.hasNext()) {
                cycleString = cycleString + iter.next().toString() + ", ";
            }
            cycleString = cycleString + target.toString();
            throw new RuntimeException(NLS.bind((String)error_pluginCycle, (Object)cycleString));
        }
        if (addedPlugins.contains(target)) {
            return;
        }
        BundleDescription[] requires = OsgiStateController.getDependentBundles((BundleDescription)target);
        pluginChain.add(target);
        for (int i = 0; i < requires.length; ++i) {
            this.addPluginAndPrerequisites(requires[i], classpath, pluginChain, addedPlugins);
        }
        pluginChain.remove(target);
        addedPlugins.add(target);
    }

    private void addPluginAndPrerequisites(BundleDescription target, List classpath, List pluginChain, Set addedPlugins) {
        if (!target.isResolved()) {
            return;
        }
        this.addPlugin(target, classpath);
        this.addPrerequisites(target, classpath, pluginChain, addedPlugins);
    }

    private String[] getBundleClasspath(BundleDescription bundle) {
        String[] result = new String[]{"."};
        String classpath = this.state.getManifestAttribute(bundle, "Bundle-ClassPath");
        if (classpath != null) {
            try {
                ManifestElement[] classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
                result = new String[classpathEntries.length];
                for (int i = 0; i < classpathEntries.length; ++i) {
                    result[i] = classpathEntries[i].getValue();
                }
            }
            catch (BundleException e) {
                // empty catch block
            }
        }
        return result;
    }

    public static class ClasspathElement {
        private String path;
        private String accessRules;

        public ClasspathElement(String path, String accessRules) {
            this.path = path;
            this.accessRules = accessRules;
        }

        public String toString() {
            return this.path;
        }

        public String getPath() {
            return this.path;
        }

        public String getAccessRules() {
            return this.accessRules;
        }

        public void addRules(String newRule) {
            if (this.accessRules.equals("") || this.accessRules.equals(newRule)) {
                return;
            }
            if (!newRule.equals("")) {
                String join = this.accessRules.substring(0, this.accessRules.length() - ClasspathComputer3_0.EXCLUDE_ALL_RULE.length() - 1);
                newRule = join + newRule.substring(1);
            }
            this.accessRules = newRule;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClasspathElement) {
                ClasspathElement element = (ClasspathElement)obj;
                return this.path != null && this.path.equals(element.getPath());
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public static String normalize(String path) {
            return path.replaceAll("\\\\", "/");
        }
    }
}

