/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.unmarshallers;

import org.sonar.wsclient.services.TimeMachine;
import org.sonar.wsclient.services.TimeMachineCell;
import org.sonar.wsclient.services.TimeMachineColumn;
import org.sonar.wsclient.services.WSUtils;
import org.sonar.wsclient.unmarshallers.AbstractUnmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeMachineUnmarshaller
extends AbstractUnmarshaller<TimeMachine> {
    @Override
    protected TimeMachine parse(Object json) {
        WSUtils utils = WSUtils.getINSTANCE();
        Object cols = utils.getField(json, "cols");
        Object cells = utils.getField(json, "cells");
        return new TimeMachine(this.toColumns(cols), this.toCells(cells));
    }

    private TimeMachineColumn[] toColumns(Object cols) {
        WSUtils utils = WSUtils.getINSTANCE();
        int size = utils.getArraySize(cols);
        TimeMachineColumn[] result = new TimeMachineColumn[size];
        for (int index = 0; index < size; ++index) {
            Object colJson = utils.getArrayElement(cols, index);
            result[index] = new TimeMachineColumn(index, utils.getString(colJson, "metric"), null, null);
        }
        return result;
    }

    private TimeMachineCell[] toCells(Object cells) {
        WSUtils utils = WSUtils.getINSTANCE();
        int size = utils.getArraySize(cells);
        TimeMachineCell[] result = new TimeMachineCell[size];
        for (int i = 0; i < size; ++i) {
            Object cellJson = utils.getArrayElement(cells, i);
            Object valuesJson = utils.getField(cellJson, "v");
            Object[] resultValues = new Object[utils.getArraySize(valuesJson)];
            for (int indexValue = 0; indexValue < utils.getArraySize(valuesJson); ++indexValue) {
                Object value;
                resultValues[indexValue] = value = utils.getArrayElement(valuesJson, indexValue);
            }
            result[i] = new TimeMachineCell(utils.getDateTime(cellJson, "d"), resultValues);
        }
        return result;
    }
}

