/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import java.util.Date;
import org.sonar.wsclient.services.Model;
import org.sonar.wsclient.services.WSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery<M extends Model> {
    public static final int DEFAULT_TIMEOUT_MILLISECONDS = 30000;
    private int timeoutMilliseconds = 30000;
    private String locale;

    public abstract String getUrl();

    public String getBody() {
        return null;
    }

    public final int getTimeoutMilliseconds() {
        return this.timeoutMilliseconds;
    }

    public final AbstractQuery<M> setTimeoutMilliseconds(int i) {
        this.timeoutMilliseconds = i < 0 ? 0 : i;
        return this;
    }

    public final String getLocale() {
        return this.locale;
    }

    public final AbstractQuery<M> setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    protected static String encode(String value) {
        return WSUtils.getINSTANCE().encodeUrl(value);
    }

    protected static void appendUrlParameter(StringBuilder url, String paramKey, int paramValue) {
        url.append(paramKey).append('=').append(paramValue).append("&");
    }

    protected static void appendUrlParameter(StringBuilder url, String paramKey, Object paramValue) {
        if (paramValue != null) {
            url.append(paramKey).append('=').append(AbstractQuery.encode(paramValue.toString())).append('&');
        }
    }

    protected static void appendUrlParameter(StringBuilder url, String paramKey, Object[] paramValues) {
        if (paramValues != null) {
            url.append(paramKey).append('=');
            for (int index = 0; index < paramValues.length; ++index) {
                if (index > 0) {
                    url.append(',');
                }
                if (paramValues[index] == null) continue;
                url.append(AbstractQuery.encode(paramValues[index].toString()));
            }
            url.append('&');
        }
    }

    protected static void appendUrlParameter(StringBuilder url, String paramKey, Date paramValue, boolean includeTime) {
        if (paramValue != null) {
            String format = includeTime ? "yyyy-MM-dd'T'HH:mm:ssZ" : "yyyy-MM-dd";
            url.append(paramKey).append('=').append(AbstractQuery.encode(WSUtils.getINSTANCE().format(paramValue, format))).append('&');
        }
    }
}

