/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.unmarshallers;

import org.sonar.wsclient.services.Violation;
import org.sonar.wsclient.services.WSUtils;
import org.sonar.wsclient.unmarshallers.AbstractUnmarshaller;
import org.sonar.wsclient.unmarshallers.ReviewUnmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolationUnmarshaller
extends AbstractUnmarshaller<Violation> {
    @Override
    protected Violation parse(Object json) {
        Object resource;
        Object rule;
        WSUtils utils = WSUtils.getINSTANCE();
        Violation violation = new Violation();
        violation.setId(utils.getLong(json, "id"));
        violation.setMessage(utils.getString(json, "message"));
        violation.setLine(utils.getInteger(json, "line"));
        violation.setSeverity(utils.getString(json, "priority"));
        violation.setCreatedAt(utils.getDateTime(json, "createdAt"));
        violation.setSwitchedOff(utils.getBoolean(json, "switchedOff"));
        Object review = utils.getField(json, "review");
        if (review != null) {
            ReviewUnmarshaller reviewUnmarshaller = new ReviewUnmarshaller();
            violation.setReview(reviewUnmarshaller.parse(review));
        }
        if ((rule = utils.getField(json, "rule")) != null) {
            violation.setRuleKey(utils.getString(rule, "key"));
            violation.setRuleName(utils.getString(rule, "name"));
        }
        if ((resource = utils.getField(json, "resource")) != null) {
            violation.setResourceKey(utils.getString(resource, "key"));
            violation.setResourceName(utils.getString(resource, "name"));
            violation.setResourceQualifier(utils.getString(resource, "qualifier"));
            violation.setResourceScope(utils.getString(resource, "scope"));
        }
        return violation;
    }
}

