/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.unmarshallers;

import java.util.ArrayList;
import java.util.List;
import org.sonar.wsclient.services.Rule;
import org.sonar.wsclient.services.RuleParam;
import org.sonar.wsclient.services.WSUtils;
import org.sonar.wsclient.unmarshallers.AbstractUnmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleUnmarshaller
extends AbstractUnmarshaller<Rule> {
    @Override
    protected Rule parse(Object json) {
        Rule rule = new Rule();
        this.parseRuleFields(json, rule);
        this.parseParams(json, rule);
        return rule;
    }

    private void parseRuleFields(Object json, Rule rule) {
        WSUtils utils = WSUtils.getINSTANCE();
        rule.setTitle(utils.getString(json, "title")).setKey(utils.getString(json, "key")).setConfigKey(utils.getString(json, "config_key")).setRepository(utils.getString(json, "plugin")).setDescription(utils.getString(json, "description")).setSeverity(utils.getString(json, "priority")).setActive("ACTIVE".equals(utils.getString(json, "status")));
    }

    private void parseParams(Object json, Rule rule) {
        WSUtils utils = WSUtils.getINSTANCE();
        Object paramsJson = utils.getField(json, "params");
        if (paramsJson != null) {
            rule.setParams(this.parseParams(paramsJson));
        }
    }

    private List<RuleParam> parseParams(Object paramsJson) {
        WSUtils utils = WSUtils.getINSTANCE();
        ArrayList<RuleParam> ruleParams = new ArrayList<RuleParam>();
        int len = utils.getArraySize(paramsJson);
        for (int i = 0; i < len; ++i) {
            Object paramJson = utils.getArrayElement(paramsJson, i);
            if (paramJson == null) continue;
            RuleParam param = this.parseParam(paramJson);
            ruleParams.add(param);
        }
        return ruleParams;
    }

    private RuleParam parseParam(Object json) {
        WSUtils utils = WSUtils.getINSTANCE();
        RuleParam param = new RuleParam();
        param.setName(utils.getString(json, "name")).setDescription(utils.getString(json, "description")).setValue(utils.getString(json, "value"));
        return param;
    }
}

