/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.DependencyTree;
import org.sonar.wsclient.services.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTreeQuery
extends Query<DependencyTree> {
    private static final String BASE_URL = "/api/dependency_tree";
    private String resourceId;
    private String[] scopes;

    public DependencyTreeQuery(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public DependencyTreeQuery setResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public DependencyTreeQuery setScopes(String ... scopes) {
        this.scopes = scopes;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append('?');
        DependencyTreeQuery.appendUrlParameter(url, "resource", this.resourceId);
        DependencyTreeQuery.appendUrlParameter(url, "scopes", this.scopes);
        return url.toString();
    }

    @Override
    public Class<DependencyTree> getModelClass() {
        return DependencyTree.class;
    }

    public static DependencyTreeQuery createForResource(String resourceIdOrKey) {
        return new DependencyTreeQuery(resourceIdOrKey);
    }

    public static DependencyTreeQuery createForProject(String projectIdOrKey) {
        return new DependencyTreeQuery(projectIdOrKey).setScopes("PRJ");
    }
}

