/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.sonar.wsclient.services.WSUtils;
import org.sonar.wsclient.unmarshallers.JsonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JdkUtils
extends WSUtils {
    @Override
    public String format(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    @Override
    public String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getField(Object json, String field) {
        return ((JSONObject)json).get((Object)field);
    }

    @Override
    public String getString(Object json, String field) {
        return JsonUtils.getString((Map)((JSONObject)json), field);
    }

    @Override
    public Boolean getBoolean(Object json, String field) {
        return JsonUtils.getBoolean((Map)((JSONObject)json), field);
    }

    @Override
    public Integer getInteger(Object json, String field) {
        return JsonUtils.getInteger((Map)((JSONObject)json), field);
    }

    @Override
    public Double getDouble(Object json, String field) {
        return JsonUtils.getDouble((Map)((JSONObject)json), field);
    }

    @Override
    public Long getLong(Object json, String field) {
        return JsonUtils.getLong((Map)((JSONObject)json), field);
    }

    @Override
    public Date getDateTime(Object json, String field) {
        return JsonUtils.getDateTime((Map)((JSONObject)json), field);
    }

    @Override
    public int getArraySize(Object array) {
        return ((ArrayList)array).size();
    }

    @Override
    public Object getArrayElement(Object array, int i) {
        return ((ArrayList)array).get(i);
    }

    @Override
    public Object parse(String jsonStr) {
        return JSONValue.parse((String)jsonStr);
    }

    @Override
    public Set<String> getFields(Object json) {
        return ((JSONObject)json).keySet();
    }
}

