/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import org.picocontainer.ComponentAdapter;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.database.daos.MeasuresDao;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.DefaultProjectFileSystem;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.DefaultRulesManager;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.CheckProfileProvider;
import org.sonar.batch.DefaultProfileLoader;
import org.sonar.batch.DefaultSensorContext;
import org.sonar.batch.DefaultTimeMachine;
import org.sonar.batch.Module;
import org.sonar.batch.ProfileLoader;
import org.sonar.batch.ProfileProvider;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.components.PastViolationsLoader;
import org.sonar.batch.components.TimeMachineConfiguration;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.phases.PhasesTimeProfiler;
import org.sonar.core.components.DefaultModelFinder;
import org.sonar.jpa.dao.AsyncMeasuresDao;
import org.sonar.jpa.dao.AsyncMeasuresService;
import org.sonar.jpa.dao.DaoFacade;
import org.sonar.jpa.dao.ProfilesDao;
import org.sonar.jpa.dao.RulesDao;

public class ProjectBatch {
    private Module globalComponents;

    public ProjectBatch(Module globalComponents) {
        this.globalComponents = globalComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DefaultIndex index, Project project) {
        Module projectComponents = null;
        try {
            projectComponents = this.startChildContainer(index, project);
            projectComponents.getComponent(Phases.class).execute(project);
        }
        finally {
            if (projectComponents != null) {
                try {
                    this.globalComponents.uninstallChild(projectComponents);
                    projectComponents.stop();
                }
                catch (Exception e) {}
            }
        }
    }

    public Module startChildContainer(DefaultIndex index, Project project) {
        Module projectComponents = this.globalComponents.installChild(new ProjectComponents(project));
        projectComponents.install(new ProjectCoreComponents());
        projectComponents.start();
        Language language = projectComponents.getComponent(Languages.class).get(project.getLanguageKey());
        if (language == null) {
            throw new SonarException("Language with key '" + project.getLanguageKey() + "' not found");
        }
        project.setLanguage(language);
        index.setCurrentProject(project, projectComponents.getComponent(ResourceFilters.class), projectComponents.getComponent(ViolationFilters.class), projectComponents.getComponent(RulesProfile.class));
        project.setFileSystem(projectComponents.getComponent(ProjectFileSystem.class));
        return projectComponents;
    }

    private static class ProjectCoreComponents
    extends Module {
        private ProjectCoreComponents() {
        }

        protected void configure() {
            this.addComponent(EventBus.class);
            this.addComponent(Phases.class);
            this.addComponent(PhasesTimeProfiler.class);
            for (Class clazz : Phases.getPhaseClasses()) {
                this.addComponent(clazz);
            }
            for (Metric metric : CoreMetrics.getMetrics()) {
                this.addComponent(metric.getKey(), metric);
            }
            for (Metrics metricRepo : this.getComponents(Metrics.class)) {
                for (Metric metric : metricRepo.getMetrics()) {
                    this.addComponent(metric.getKey(), metric);
                }
            }
        }
    }

    private static class ProjectComponents
    extends Module {
        private Project project;

        public ProjectComponents(Project project) {
            this.project = project;
        }

        protected void configure() {
            this.addComponent(this.project);
            this.addComponent(this.project.getPom());
            this.addComponent(ProjectClasspath.class);
            this.addComponent(DefaultProjectFileSystem.class);
            this.addComponent(this.project.getConfiguration());
            this.getComponent(BatchPluginRepository.class).registerPlugins(this.getContainer());
            this.addComponent(DaoFacade.class);
            this.addComponent(RulesDao.class);
            this.addComponent(this.getComponent(DefaultResourcePersister.class).getSnapshot((Resource)this.project));
            this.addComponent(MeasuresDao.class);
            this.addComponent(ProfilesDao.class);
            this.addComponent(AsyncMeasuresDao.class);
            this.addComponent(AsyncMeasuresService.class);
            this.addComponent(DefaultRulesManager.class);
            this.addComponent(DefaultSensorContext.class);
            this.addComponent(Languages.class);
            this.addComponent(BatchExtensionDictionnary.class);
            this.addComponent(DefaultTimeMachine.class);
            this.addComponent(ViolationFilters.class);
            this.addComponent(ResourceFilters.class);
            this.addComponent(DefaultModelFinder.class);
            this.addComponent(TimeMachineConfiguration.class);
            this.addComponent(PastViolationsLoader.class);
            this.addComponent(ProfileLoader.class, DefaultProfileLoader.class);
            this.addAdapter((ComponentAdapter<?>)new ProfileProvider());
            this.addAdapter((ComponentAdapter<?>)new CheckProfileProvider());
        }
    }
}

