/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.Query;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.Logs;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.PastSnapshotFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeMachineConfiguration
implements BatchExtension {
    private static final int NUMBER_OF_VARIATION_SNAPSHOTS = 5;
    private Project project;
    private final Configuration configuration;
    private List<PastSnapshot> projectPastSnapshots;
    private DatabaseSession session;

    public TimeMachineConfiguration(DatabaseSession session, Project project, Configuration configuration, PastSnapshotFinder pastSnapshotFinder) {
        this.session = session;
        this.project = project;
        this.configuration = configuration;
        this.initPastSnapshots(pastSnapshotFinder);
    }

    private void initPastSnapshots(PastSnapshotFinder pastSnapshotFinder) {
        Snapshot projectSnapshot = this.buildProjectSnapshot();
        this.projectPastSnapshots = Lists.newLinkedList();
        if (projectSnapshot != null) {
            for (int index = 1; index <= 5; ++index) {
                PastSnapshot pastSnapshot = pastSnapshotFinder.find(projectSnapshot, this.configuration, index);
                if (pastSnapshot == null) continue;
                this.log(pastSnapshot);
                this.projectPastSnapshots.add(pastSnapshot);
            }
        }
    }

    private Snapshot buildProjectSnapshot() {
        Query query = this.session.createNativeQuery("select p.id from projects p where p.kee=:resourceKey and p.qualifier<>:lib and p.enabled=:enabled");
        query.setParameter("resourceKey", (Object)this.project.getKey());
        query.setParameter("lib", (Object)"LIB");
        query.setParameter("enabled", (Object)Boolean.TRUE);
        Snapshot snapshot = null;
        Number projectId = (Number)this.session.getSingleResult(query, null);
        if (projectId != null) {
            snapshot = new Snapshot();
            snapshot.setResourceId(Integer.valueOf(projectId.intValue()));
            snapshot.setCreatedAt(this.project.getAnalysisDate());
        }
        return snapshot;
    }

    private void log(PastSnapshot pastSnapshot) {
        String qualifier = pastSnapshot.getQualifier();
        if (StringUtils.equals((String)"VW", (String)qualifier) || StringUtils.equals((String)"SVW", (String)qualifier)) {
            LoggerFactory.getLogger(this.getClass()).debug(pastSnapshot.toString());
        } else {
            Logs.INFO.info(pastSnapshot.toString());
        }
    }

    public boolean skipTendencies() {
        return this.configuration.getBoolean("sonar.skipTendencies", false);
    }

    public int getTendencyPeriodInDays() {
        return this.configuration.getInt("tendency.depth", 30);
    }

    public List<PastSnapshot> getProjectPastSnapshots() {
        return this.projectPastSnapshots;
    }

    public boolean isFileVariationEnabled() {
        return this.configuration.getBoolean("sonar.enableFileVariation", Boolean.FALSE);
    }
}

