/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner;

import java.util.Map;
import java.util.Properties;
import org.sonar.runner.impl.Logs;

class Cli {
    private boolean debugMode = false;
    private boolean displayVersionOnly = false;
    private boolean displayStackTrace = false;
    private Properties props = new Properties();

    Cli() {
    }

    boolean isDebugMode() {
        return this.debugMode;
    }

    boolean isDisplayVersionOnly() {
        return this.displayVersionOnly;
    }

    boolean isDisplayStackTrace() {
        return this.displayStackTrace;
    }

    Properties properties() {
        return this.props;
    }

    Cli parse(String[] args) {
        this.reset();
        this.props.putAll((Map<?, ?>)System.getProperties());
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (i == 0 && !arg.startsWith("-")) {
                this.props.setProperty("sonar.task", arg);
                continue;
            }
            if ("-h".equals(arg) || "--help".equals(arg)) {
                this.printUsage();
                continue;
            }
            if ("-v".equals(arg) || "--version".equals(arg)) {
                this.displayVersionOnly = true;
                continue;
            }
            if ("-e".equals(arg) || "--errors".equals(arg)) {
                this.displayStackTrace = true;
                continue;
            }
            if ("-X".equals(arg) || "--debug".equals(arg)) {
                this.props.setProperty("sonar.verbose", "true");
                this.displayStackTrace = true;
                this.debugMode = true;
                Logs.setDebugEnabled(true);
                continue;
            }
            if ("-D".equals(arg) || "--define".equals(arg)) {
                if (++i >= args.length) {
                    this.printError("Missing argument for option --define");
                }
                arg = args[i];
                this.appendPropertyTo(arg, this.props);
                continue;
            }
            if (arg.startsWith("-D")) {
                arg = arg.substring(2);
                this.appendPropertyTo(arg, this.props);
                continue;
            }
            this.printError("Unrecognized option: " + arg);
        }
        return this;
    }

    private void reset() {
        this.props.clear();
        this.debugMode = false;
        this.displayStackTrace = false;
        this.displayVersionOnly = false;
    }

    private void appendPropertyTo(String arg, Properties props) {
        String value;
        String key;
        int j = arg.indexOf(61);
        if (j == -1) {
            key = arg;
            value = "true";
        } else {
            key = arg.substring(0, j);
            value = arg.substring(j + 1);
        }
        props.setProperty(key, value);
    }

    private void printError(String message) {
        Logs.error(message);
        this.printUsage();
    }

    private void printUsage() {
        Logs.info("");
        Logs.info("usage: sonar-runner [options]");
        Logs.info("");
        Logs.info("Options:");
        Logs.info(" -D,--define <arg>     Define property");
        Logs.info(" -e,--errors           Produce execution error messages");
        Logs.info(" -h,--help             Display help information");
        Logs.info(" -v,--version          Display version information");
        Logs.info(" -X,--debug            Produce execution debug output");
        System.exit(0);
    }
}

