/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.nio.charset.Charset;
import java.util.Locale;
import org.sonar.runner.api.Runner;
import org.sonar.runner.api.Utils;
import org.sonar.runner.impl.Logs;

class SourceEncoding {
    SourceEncoding() {
    }

    void init(Runner runner) {
        boolean onProject = Utils.taskRequiresProject(runner.properties());
        if (onProject) {
            String sourceEncoding = runner.property("sonar.sourceEncoding", "");
            boolean platformDependent = false;
            if ("".equals(sourceEncoding)) {
                sourceEncoding = Charset.defaultCharset().name();
                platformDependent = true;
                runner.setProperty("sonar.sourceEncoding", sourceEncoding);
            }
            Logs.info("Default locale: \"" + Locale.getDefault() + "\", source code encoding: \"" + sourceEncoding + "\"" + (platformDependent ? " (analysis is platform dependent)" : ""));
        }
    }
}

