/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.buildbreaker;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BuildBreaker;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;

public class AlertThresholdChecker
extends BuildBreaker {
    public void executeOn(Project project, SensorContext context) {
        this.analyseMeasures(context, LoggerFactory.getLogger(((Object)((Object)this)).getClass()));
    }

    protected void analyseMeasures(SensorContext context, Logger logger) {
        int count = this.countErrors(context, logger);
        if (count > 0) {
            this.fail("Alert thresholds have been hit (" + count + " times).");
        }
    }

    private int countErrors(SensorContext context, Logger logger) {
        Collection measures = (Collection)context.getMeasures(MeasuresFilters.all());
        int count = 0;
        for (Measure measure : measures) {
            if (this.isErrorAlert(measure)) {
                logger.error(measure.getAlertText());
                ++count;
                continue;
            }
            if (!this.isWarningAlert(measure)) continue;
            logger.warn(measure.getAlertText());
        }
        return count;
    }

    private boolean isWarningAlert(Measure measure) {
        return !measure.getMetric().equals((Object)CoreMetrics.ALERT_STATUS) && Metric.Level.WARN.equals((Object)measure.getAlertStatus());
    }

    private boolean isErrorAlert(Measure measure) {
        return !measure.getMetric().equals((Object)CoreMetrics.ALERT_STATUS) && Metric.Level.ERROR.equals((Object)measure.getAlertStatus());
    }
}

