/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.ide.test.SonarTestServer;

public abstract class TestServlet
extends GenericServlet {
    private static final String DEFAULT_PACKAGE_NAME = "[default]";

    protected abstract String getResource(String var1);

    protected File getResourceAsFile(String testName, String classKey) {
        return new File(TestServlet.getBaseDir(this) + "/" + testName + "/" + this.getResource(classKey));
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String json;
        PrintWriter out = response.getWriter();
        try {
            String resourceKey = request.getParameter("resource");
            String[] parts = resourceKey.split(":");
            String groupId = parts[0];
            String artifactId = parts[1];
            String classKey = parts[2];
            SonarTestServer.LOG.debug("Loading data for {}:{}:{}", new Object[]{groupId, artifactId, classKey});
            if (classKey.startsWith(DEFAULT_PACKAGE_NAME)) {
                classKey = StringUtils.substringAfter((String)classKey, (String)".");
            }
            String testName = StringUtils.contains((String)groupId, (String)".") ? StringUtils.substringAfterLast((String)groupId, (String)".") : groupId;
            File resourceFile = this.getResourceAsFile(testName, classKey);
            SonarTestServer.LOG.info("Resource file: {}", (Object)resourceFile);
            json = FileUtils.readFileToString((File)resourceFile);
        }
        catch (Exception e) {
            SonarTestServer.LOG.error(e.getMessage(), (Throwable)e);
            json = "[]";
        }
        out.println(json);
    }

    public static String getBaseDir(GenericServlet servlet) {
        return StringUtils.defaultIfEmpty((String)servlet.getServletConfig().getInitParameter("baseDir"), (String)"target/sonar-data");
    }
}

