/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.test;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.ide.test.HttpServer;
import org.sonar.ide.test.MeasureServlet;
import org.sonar.ide.test.MetricServlet;
import org.sonar.ide.test.SourceServlet;
import org.sonar.ide.test.VersionServlet;
import org.sonar.ide.test.ViolationServlet;
import org.sonar.wsclient.Host;

public class SonarTestServer
extends HttpServer {
    protected static final Logger LOG = LoggerFactory.getLogger(SonarTestServer.class);

    public SonarTestServer() {
        this(0, "");
    }

    public SonarTestServer(int port, String baseDir) {
        this.setContextPath("/").setHttpPort(port).setBaseDir(baseDir).addServlet(VersionServlet.class, "/api/server/index").addServlet(ViolationServlet.class, "/api/violations").addServlet(SourceServlet.class, "/api/sources").addServlet(MeasureServlet.class, "/api/resources").addServlet(MetricServlet.class, "/api/metrics");
    }

    public HttpServer start() throws Exception {
        super.start();
        LOG.info("Sonar test server started: {}", (Object)this.getBaseUrl());
        return this;
    }

    public void stop() {
        super.stop();
        LOG.info("Sonar test server stopped: {}", (Object)this.getBaseUrl());
    }

    public String getBaseUrl() {
        return this.getHttpUrl();
    }

    public Host getHost() {
        return new Host(this.getBaseUrl());
    }

    public static void main(String[] args) throws Exception {
        new SonarTestServer(9000, "sonar-data").start();
    }
}

