/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.wsclient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.ide.api.IMeasure;
import org.sonar.ide.api.Logs;
import org.sonar.ide.api.SourceCode;
import org.sonar.ide.api.SourceCodeDiff;
import org.sonar.ide.shared.coverage.CoverageData;
import org.sonar.ide.shared.coverage.CoverageUtils;
import org.sonar.ide.shared.duplications.Duplication;
import org.sonar.ide.shared.duplications.DuplicationUtils;
import org.sonar.ide.shared.measures.MeasureData;
import org.sonar.ide.shared.violations.ViolationUtils;
import org.sonar.ide.wsclient.ProperViolationQuery;
import org.sonar.ide.wsclient.RemoteSonarIndex;
import org.sonar.ide.wsclient.SimpleSourceCodeDiffEngine;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Metric;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;
import org.sonar.wsclient.services.Source;
import org.sonar.wsclient.services.SourceQuery;
import org.sonar.wsclient.services.Violation;
import org.sonar.wsclient.services.ViolationQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteSourceCode
implements SourceCode {
    private final String key;
    private final String name;
    private RemoteSonarIndex index;
    private String localContent;
    private SourceCodeDiff diff;
    private String[] remoteContent;
    private Set<SourceCode> children;

    public RemoteSourceCode(String key) {
        this(key, null);
    }

    public RemoteSourceCode(String key, String name) {
        this.key = key;
        this.name = name;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<SourceCode> getChildren() {
        if (this.children == null) {
            ResourceQuery query = new ResourceQuery().setDepth(Integer.valueOf(1)).setResourceKeyOrId(this.getKey());
            List resources = this.index.getSonar().findAll((Query)query);
            this.children = new HashSet<SourceCode>();
            for (Resource resource : resources) {
                this.children.add(new RemoteSourceCode(resource.getKey(), resource.getName()).setRemoteSonarIndex(this.index));
            }
        }
        return this.children;
    }

    @Override
    public SourceCode setLocalContent(String content) {
        this.localContent = content;
        return this;
    }

    private String getLocalContent() {
        if (this.localContent == null) {
            return "";
        }
        return this.localContent;
    }

    private String[] getRemoteContentAsArray() {
        if (this.remoteContent == null) {
            this.remoteContent = SimpleSourceCodeDiffEngine.getLines(this.getCode());
        }
        return this.remoteContent;
    }

    @Override
    public String getRemoteContent() {
        return StringUtils.join((Object[])this.getRemoteContentAsArray(), (String)"\n");
    }

    private SourceCodeDiff getDiff() {
        if (this.diff == null) {
            this.diff = this.index.getDiffEngine().diff(SimpleSourceCodeDiffEngine.split(this.getLocalContent()), this.getRemoteContentAsArray());
        }
        return this.diff;
    }

    @Override
    public List<IMeasure> getMeasures() {
        Map<String, Metric> metricsByKey = this.index.getMetrics();
        Set<String> keys = metricsByKey.keySet();
        String[] metricKeys = keys.toArray(new String[keys.size()]);
        ResourceQuery query = ResourceQuery.createForMetrics((String)this.getKey(), (String[])metricKeys);
        Resource resource = (Resource)this.index.getSonar().find((Query)query);
        ArrayList result = Lists.newArrayList();
        for (Measure measure : resource.getMeasures()) {
            Metric metric = metricsByKey.get(measure.getMetricKey());
            String value = measure.getFormattedValue();
            if (metric.getHidden().booleanValue() || "DATA".equals(metric.getType()) || !StringUtils.isNotBlank((String)measure.getFormattedValue())) continue;
            result.add(new MeasureData().setMetricDef(metric).setValue(value));
        }
        return result;
    }

    @Override
    public CoverageData getCoverage() {
        Resource resource = (Resource)this.index.getSonar().find((Query)ResourceQuery.createForMetrics((String)this.getKey(), (String[])new String[]{"coverage_line_hits_data", "branch_coverage_hits_data"}));
        Measure measure = resource.getMeasure("coverage_line_hits_data");
        Measure measure2 = resource.getMeasure("branch_coverage_hits_data");
        if (measure2 != null) {
            return new CoverageData(CoverageUtils.unmarshall(measure.getData()), CoverageUtils.unmarshall(measure2.getData()));
        }
        return new CoverageData(CoverageUtils.unmarshall(measure.getData()), new HashMap<Integer, String>());
    }

    @Override
    public List<Violation> getViolations() {
        Logs.INFO.info("Loading violations for {}", (Object)this.getKey());
        List violations = this.index.getSonar().findAll((Query)ViolationQuery.createForResource((String)this.getKey()));
        Logs.INFO.info("Loaded {} violations: {}", (Object)violations.size(), (Object)ViolationUtils.toString(violations));
        return ViolationUtils.convertLines(violations, this.getDiff());
    }

    @Override
    public List<Violation> getViolations2() {
        return this.getRemoteSonarIndex().getSonar().findAll((Query)new ProperViolationQuery(this.key).setDepth(-1));
    }

    @Override
    public List<Duplication> getDuplications() {
        Logs.INFO.info("Loading duplications for {}", (Object)this.getKey());
        Resource resource = (Resource)this.index.getSonar().find((Query)ResourceQuery.createForMetrics((String)this.getKey(), (String[])new String[]{"duplications_data"}));
        Measure measure = resource.getMeasure("duplications_data");
        if (measure == null) {
            return Collections.emptyList();
        }
        List<Duplication> duplications = DuplicationUtils.parse(measure.getData());
        Logs.INFO.info("Loaded {} duplications: {}", (Object)duplications.size(), duplications);
        return DuplicationUtils.convertLines(duplications, this.getDiff());
    }

    private Source getCode() {
        return (Source)this.index.getSonar().find((Query)new SourceQuery(this.getKey()));
    }

    @Override
    public int compareTo(SourceCode resource) {
        return this.key.compareTo(resource.getKey());
    }

    public boolean equals(Object obj) {
        return obj instanceof RemoteSourceCode && this.key.equals(((RemoteSourceCode)obj).key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.key).toString();
    }

    protected RemoteSourceCode setRemoteSonarIndex(RemoteSonarIndex index) {
        this.index = index;
        return this;
    }

    protected RemoteSonarIndex getRemoteSonarIndex() {
        return this.index;
    }
}

