/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.wsclient;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sonar.ide.api.SourceCode;
import org.sonar.ide.api.SourceCodeDiffEngine;
import org.sonar.ide.api.SourceCodeSearchEngine;
import org.sonar.ide.wsclient.HttpClient3ConnectorFactory;
import org.sonar.ide.wsclient.RemoteSourceCode;
import org.sonar.wsclient.Host;
import org.sonar.wsclient.Sonar;
import org.sonar.wsclient.connectors.Connector;
import org.sonar.wsclient.services.Metric;
import org.sonar.wsclient.services.MetricQuery;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteSonarIndex
implements SourceCodeSearchEngine {
    private final Host host;
    private final Sonar sonar;
    private final SourceCodeDiffEngine diffEngine;

    protected RemoteSonarIndex(Host host) {
        this(host, null);
    }

    public RemoteSonarIndex(Host host, SourceCodeDiffEngine diffEngine) {
        this(host, new Sonar((Connector)HttpClient3ConnectorFactory.createConnector(host)), diffEngine);
    }

    private RemoteSonarIndex(Host host, Sonar sonar, SourceCodeDiffEngine diffEngine) {
        this.sonar = sonar;
        this.diffEngine = diffEngine;
        this.host = host;
    }

    @Override
    public SourceCode search(String key) {
        Resource resource = (Resource)this.sonar.find((Query)new ResourceQuery().setResourceKeyOrId(key));
        if (resource == null) {
            return null;
        }
        return new RemoteSourceCode(key).setRemoteSonarIndex(this);
    }

    @Override
    public Collection<SourceCode> getProjects() {
        ArrayList result = Lists.newArrayList();
        for (Resource resource : this.sonar.findAll((Query)new ResourceQuery())) {
            result.add(new RemoteSourceCode(resource.getKey(), resource.getName()).setRemoteSonarIndex(this));
        }
        return result;
    }

    protected Host getServer() {
        return this.host;
    }

    protected Sonar getSonar() {
        return this.sonar;
    }

    protected SourceCodeDiffEngine getDiffEngine() {
        return this.diffEngine;
    }

    public Map<String, Metric> getMetrics() {
        List metrics = this.getSonar().findAll((Query)MetricQuery.all());
        return Maps.uniqueIndex((Iterable)metrics, (Function)new Function<Metric, String>(){

            public String apply(Metric metric) {
                return metric.getKey();
            }
        });
    }
}

