/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.wsclient;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.sonar.wsclient.Host;
import org.sonar.wsclient.connectors.HttpClient3Connector;

public final class HttpClient3ConnectorFactory {
    protected static final int TIMEOUT_MS = 30000;
    private static final int MAX_TOTAL_CONNECTIONS = 40;
    private static final int MAX_HOST_CONNECTIONS = 4;

    private HttpClient3ConnectorFactory() {
    }

    public static HttpClient3Connector createConnector(Host server) {
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setConnectionTimeout(30000);
        params.setSoTimeout(30000);
        params.setDefaultMaxConnectionsPerHost(4);
        params.setMaxTotalConnections(40);
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(params);
        HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        if (server.getUsername() != null) {
            httpClient.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(server.getUsername(), server.getPassword());
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
        try {
            List<Proxy> list = ProxySelector.getDefault().select(new URI(server.getHost()));
            for (Proxy proxy : list) {
                if (proxy.type() != Proxy.Type.HTTP) continue;
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                httpClient.getHostConfiguration().setProxy(addr.getHostName(), addr.getPort());
                InetAddress proxyInetAddress = InetAddress.getByName(addr.getHostName());
                PasswordAuthentication auth = Authenticator.requestPasswordAuthentication(proxyInetAddress, addr.getPort(), null, null, null);
                if (auth == null) continue;
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(auth.getUserName(), new String(auth.getPassword()));
                httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new HttpClient3Connector(server, httpClient);
    }
}

