/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ide.shared.violations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.ide.api.SourceCodeDiff;
import org.sonar.wsclient.services.Violation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViolationUtils {
    public static final String PRIORITY_BLOCKER = "blocker";
    public static final String PRIORITY_CRITICAL = "critical";
    public static final String PRIORITY_MAJOR = "major";
    public static final String PRIORITY_MINOR = "minor";
    public static final String PRIORITY_INFO = "info";

    public static List<Violation> sortByPriority(List<Violation> violations) {
        Collections.sort(violations, new PriorityComparator());
        return violations;
    }

    public static Map<Integer, List<Violation>> splitByLines(Collection<Violation> violations) {
        HashMap<Integer, List<Violation>> violationsByLine = new HashMap<Integer, List<Violation>>();
        for (Violation violation : violations) {
            List<Violation> collection;
            if (violationsByLine.containsKey(violation.getLine())) {
                collection = (List)violationsByLine.get(violation.getLine());
            } else {
                collection = new ArrayList();
                violationsByLine.put(violation.getLine(), collection);
            }
            collection.add(violation);
        }
        return violationsByLine;
    }

    public static int convertPriority(String priority) {
        if (PRIORITY_BLOCKER.equalsIgnoreCase(priority)) {
            return 0;
        }
        if (PRIORITY_CRITICAL.equalsIgnoreCase(priority)) {
            return 1;
        }
        if (PRIORITY_MAJOR.equalsIgnoreCase(priority)) {
            return 2;
        }
        if (PRIORITY_MINOR.equalsIgnoreCase(priority)) {
            return 3;
        }
        if (PRIORITY_INFO.equalsIgnoreCase(priority)) {
            return 4;
        }
        return 4;
    }

    public static String getDescription(Violation violation) {
        return violation.getRuleName() + " : " + violation.getMessage();
    }

    public static List<Violation> convertLines(Collection<Violation> violations, SourceCodeDiff diff) {
        ArrayList<Violation> result = new ArrayList<Violation>();
        for (Violation violation : violations) {
            int newLine;
            Integer originalLine = violation.getLine();
            if (originalLine == null || originalLine == 0 || (newLine = diff.newLine(originalLine).intValue()) == -1) continue;
            violation.setLine(Integer.valueOf(newLine));
            result.add(violation);
        }
        return result;
    }

    public static String toString(Collection<Violation> violations) {
        StringBuilder sb = new StringBuilder().append('[');
        for (Violation violation : violations) {
            sb.append(ViolationUtils.toString(violation)).append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(Violation violation) {
        return new ToStringBuilder((Object)violation).append("message", (Object)violation.getMessage()).append("priority", (Object)violation.getPriority()).append("line", (Object)violation.getLine()).toString();
    }

    private ViolationUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PriorityComparator
    implements Comparator<Violation> {
        PriorityComparator() {
        }

        @Override
        public int compare(Violation o1, Violation o2) {
            int p1 = ViolationUtils.convertPriority(o1.getPriority());
            int p2 = ViolationUtils.convertPriority(o2.getPriority());
            return p1 - p2;
        }
    }
}

