package org.codehaus.plexus.util.interpolation;

/*
 * Copyright 2007 The Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import java.util.Map;

/**
 * @version $Id: MapBasedValueSource.java 5956 2007-02-28 08:26:16Z olamy $
 */
public class MapBasedValueSource
    implements ValueSource
{

    private final Map values;

    public MapBasedValueSource( Map values )
    {
        this.values = values;
    }

    public Object getValue( String expression )
    {
        return values.get( expression );
    }

}
