/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.model.io.stax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.plexus.components.secdispatcher.model.Config;
import org.codehaus.plexus.components.secdispatcher.model.ConfigProperty;
import org.codehaus.plexus.components.secdispatcher.model.SettingsSecurity;
import org.codehaus.plexus.components.secdispatcher.model.io.stax.IndentingXMLStreamWriter;

public class SecurityConfigurationStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, SettingsSecurity settingsSecurity) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(settingsSecurity.getModelEncoding(), "1.0");
        this.writeSettingsSecurity(settingsSecurity, "settingsSecurity", serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, SettingsSecurity settingsSecurity) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(stream, settingsSecurity.getModelEncoding()));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(settingsSecurity.getModelEncoding(), "1.0");
        this.writeSettingsSecurity(settingsSecurity, "settingsSecurity", serializer);
        serializer.writeEndDocument();
    }

    private void writeConfig(Config config, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (config != null) {
            serializer.writeStartElement(tagName);
            if (config.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(config.getName());
                serializer.writeEndElement();
            }
            if (config.getProperties() != null && config.getProperties().size() > 0) {
                serializer.writeStartElement("properties");
                for (ConfigProperty o : config.getProperties()) {
                    this.writeConfigProperty(o, "property", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeConfigProperty(ConfigProperty configProperty, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (configProperty != null) {
            serializer.writeStartElement(tagName);
            if (configProperty.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(configProperty.getName());
                serializer.writeEndElement();
            }
            if (configProperty.getValue() != null) {
                serializer.writeStartElement("value");
                serializer.writeCharacters(configProperty.getValue());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeSettingsSecurity(SettingsSecurity settingsSecurity, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (settingsSecurity != null) {
            serializer.setDefaultNamespace("http://codehaus-plexus.github.io/plexus-sec-dispatcher/3.0.0");
            serializer.writeStartElement(tagName);
            serializer.writeDefaultNamespace("http://codehaus-plexus.github.io/plexus-sec-dispatcher/3.0.0");
            serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://codehaus-plexus.github.io/plexus-sec-dispatcher/3.0.0 https://codehaus-plexus.github.io/xsd/plexus-sec-dispatcher-3.0.0.xsd");
            if (settingsSecurity.getModelVersion() != null) {
                serializer.writeStartElement("modelVersion");
                serializer.writeCharacters(settingsSecurity.getModelVersion());
                serializer.writeEndElement();
            }
            if (settingsSecurity.getMasterSource() != null) {
                serializer.writeStartElement("masterSource");
                serializer.writeCharacters(settingsSecurity.getMasterSource());
                serializer.writeEndElement();
            }
            if (settingsSecurity.getMasterCipher() != null) {
                serializer.writeStartElement("masterCipher");
                serializer.writeCharacters(settingsSecurity.getMasterCipher());
                serializer.writeEndElement();
            }
            if (settingsSecurity.getConfigurations() != null && settingsSecurity.getConfigurations().size() > 0) {
                serializer.writeStartElement("configurations");
                for (Config o : settingsSecurity.getConfigurations()) {
                    this.writeConfig(o, "configuration", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

