/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import javax.xml.stream.XMLStreamException;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.model.Config;
import org.codehaus.plexus.components.secdispatcher.model.ConfigProperty;
import org.codehaus.plexus.components.secdispatcher.model.SettingsSecurity;
import org.codehaus.plexus.components.secdispatcher.model.io.stax.SecurityConfigurationStaxReader;
import org.codehaus.plexus.components.secdispatcher.model.io.stax.SecurityConfigurationStaxWriter;

public final class SecUtil {
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "unknown").startsWith("Windows");

    private SecUtil() {
    }

    public static SettingsSecurity read(Path configurationFile) throws IOException {
        Objects.requireNonNull(configurationFile, "configurationFile must not be null");
        try {
            SettingsSecurity sec;
            try (InputStream in = Files.newInputStream(configurationFile, new OpenOption[0]);){
                sec = new SecurityConfigurationStaxReader().read(in);
            }
            return sec;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (XMLStreamException e) {
            throw new IOException("Parsing error", e);
        }
    }

    public static Map<String, String> getConfig(SettingsSecurity sec, String name) {
        List<Config> cl;
        if (sec != null && name != null && !(cl = sec.getConfigurations()).isEmpty()) {
            for (Config cf : cl) {
                if (!name.equals(cf.getName())) continue;
                List<ConfigProperty> pl = cf.getProperties();
                if (pl.isEmpty()) break;
                HashMap<String, String> res = new HashMap<String, String>(pl.size());
                for (ConfigProperty p : pl) {
                    res.put(p.getName(), p.getValue());
                }
                return res;
            }
        }
        return null;
    }

    public static void write(Path target, SettingsSecurity configuration, boolean doBackup) throws IOException {
        block26: {
            Objects.requireNonNull(target, "file must not be null");
            Objects.requireNonNull(configuration, "configuration must not be null");
            Path parent = Objects.requireNonNull(target.getParent(), "target must have parent");
            Files.createDirectories(parent, new FileAttribute[0]);
            Path tempFile = parent.resolve(String.valueOf(target.getFileName()) + "." + Long.toUnsignedString(ThreadLocalRandom.current().nextLong()) + ".tmp");
            configuration.setModelVersion(SecDispatcher.class.getPackage().getSpecificationVersion());
            configuration.setModelEncoding(StandardCharsets.UTF_8.name());
            try {
                try (OutputStream tempOut = Files.newOutputStream(tempFile, new OpenOption[0]);){
                    new SecurityConfigurationStaxWriter().write(tempOut, configuration);
                }
                if (doBackup && Files.isRegularFile(target, new LinkOption[0])) {
                    Files.copy(target, parent.resolve(String.valueOf(target.getFileName()) + ".bak"), StandardCopyOption.REPLACE_EXISTING);
                }
                if (IS_WINDOWS) {
                    try (InputStream is = Files.newInputStream(tempFile, new OpenOption[0]);
                         OutputStream os = Files.newOutputStream(target, new OpenOption[0]);){
                        is.transferTo(os);
                        break block26;
                    }
                }
                Files.move(tempFile, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (XMLStreamException e) {
                throw new IOException("XML Processing error", e);
            }
            finally {
                Files.deleteIfExists(tempFile);
            }
        }
    }
}

