/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class JavaModuleDescriptor {
    private String name;
    private boolean automatic;
    private Set<JavaRequires> requires = new LinkedHashSet<JavaRequires>();
    private Set<JavaExports> exports = new LinkedHashSet<JavaExports>();

    public String name() {
        return this.name;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public Set<JavaRequires> requires() {
        return Collections.unmodifiableSet(this.requires);
    }

    public Set<JavaExports> exports() {
        return Collections.unmodifiableSet(this.exports);
    }

    public static Builder newModule(String name) {
        return new Builder(name).setAutomatic(false);
    }

    public static Builder newAutomaticModule(String name) {
        return new Builder(name).setAutomatic(true);
    }

    public static class JavaExports {
        private final String source;
        private final Set<String> targets;

        private JavaExports(String source) {
            this.source = source;
            this.targets = null;
        }

        public JavaExports(String source, Set<String> targets) {
            this.source = source;
            this.targets = targets;
        }

        public String source() {
            return this.source;
        }

        public Set<String> targets() {
            return this.targets;
        }
    }

    public static class JavaRequires {
        private final String name;

        private JavaRequires(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }
    }

    public static final class Builder {
        private JavaModuleDescriptor jModule = new JavaModuleDescriptor();

        private Builder(String name) {
            this.jModule.name = name;
        }

        private Builder setAutomatic(boolean isAutomatic) {
            this.jModule.automatic = isAutomatic;
            return this;
        }

        public Builder requires(String name) {
            JavaRequires requires = new JavaRequires(name);
            this.jModule.requires.add(requires);
            return this;
        }

        public Builder exports(String source) {
            JavaExports exports = new JavaExports(source);
            this.jModule.exports.add(exports);
            return this;
        }

        public Builder exports(String source, Set<String> targets) {
            JavaExports exports = new JavaExports(source, targets);
            this.jModule.exports.add(exports);
            return this;
        }

        public JavaModuleDescriptor build() {
            return this.jModule;
        }
    }
}

