/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;

public abstract class ResolvePathsRequest<T> {
    private File jdkHome;
    private JavaModuleDescriptor mainModuleDescriptor;
    private Collection<T> pathElements;

    private ResolvePathsRequest() {
    }

    public static ResolvePathsRequest<File> withFiles(Collection<File> files) {
        ResolvePathsRequest<File> request = new ResolvePathsRequest<File>(){

            @Override
            protected Path toPath(File t) {
                return t.toPath();
            }
        };
        request.pathElements = files;
        return request;
    }

    public static ResolvePathsRequest<Path> withPaths(Collection<Path> paths) {
        ResolvePathsRequest<Path> request = new ResolvePathsRequest<Path>(){

            @Override
            protected Path toPath(Path t) {
                return t;
            }
        };
        request.pathElements = paths;
        return request;
    }

    public static ResolvePathsRequest<String> withStrings(Collection<String> strings) {
        ResolvePathsRequest<String> request = new ResolvePathsRequest<String>(){

            @Override
            protected Path toPath(String t) {
                return Paths.get(t, new String[0]);
            }
        };
        request.pathElements = strings;
        return request;
    }

    protected abstract Path toPath(T var1);

    final ResolvePathsResult<T> createResult() {
        return new ResolvePathsResult();
    }

    public JavaModuleDescriptor getMainModuleDescriptor() {
        return this.mainModuleDescriptor;
    }

    public ResolvePathsRequest<T> setMainModuleDescriptor(JavaModuleDescriptor mainModuleDescriptor) {
        this.mainModuleDescriptor = mainModuleDescriptor;
        return this;
    }

    public Collection<T> getPathElements() {
        return this.pathElements;
    }

    public void setJdkHome(File jdkHome) {
        this.jdkHome = jdkHome;
    }

    public File getJdkHome() {
        return this.jdkHome;
    }
}

