/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Set;
import org.codehaus.plexus.languages.java.jpms.ModuleNameExtractor;

public class ReflectModuleNameExtractor
implements ModuleNameExtractor {
    @Override
    public String extract(File modulePath) throws IOException {
        String name = null;
        try {
            Class<?> moduleFinderClass = Class.forName("java.lang.module.ModuleFinder");
            Method ofMethod = moduleFinderClass.getMethod("of", Path[].class);
            Object moduleFinderInstance = ofMethod.invoke(null, new Object[]{new Path[]{modulePath.toPath()}});
            Method findAllMethod = moduleFinderClass.getMethod("findAll", new Class[0]);
            Set moduleReferences = (Set)findAllMethod.invoke(moduleFinderInstance, new Object[0]);
            if (moduleReferences.isEmpty()) {
                return null;
            }
            Object moduleReference = moduleReferences.iterator().next();
            Method descriptorMethod = moduleReference.getClass().getMethod("descriptor", new Class[0]);
            Object moduleDescriptorInstance = descriptorMethod.invoke(moduleReference, new Object[0]);
            Method nameMethod = moduleDescriptorInstance.getClass().getMethod("name", new Class[0]);
            name = (String)nameMethod.invoke(moduleDescriptorInstance, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return name;
    }
}

