/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.components.io.attributes.Java7FileAttributes;
import org.codehaus.plexus.components.io.attributes.Java7Reflector;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollectionWithAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusIoFileResourceCollection
extends AbstractPlexusIoResourceCollectionWithAttributes {
    public static final String ROLE_HINT = "files";
    private File baseDir;
    private boolean isFollowingSymLinks = true;

    public PlexusIoFileResourceCollection() {
    }

    public PlexusIoFileResourceCollection(Logger logger) {
        super(logger);
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public boolean isFollowingSymLinks() {
        return this.isFollowingSymLinks;
    }

    public void setFollowingSymLinks(boolean pIsFollowingSymLinks) {
        this.isFollowingSymLinks = pIsFollowingSymLinks;
    }

    public void setDefaultAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setDefaultFileAttributes(PlexusIoFileResourceCollection.createDefaults(uid, userName, gid, groupName, fileMode));
        this.setDefaultDirAttributes(PlexusIoFileResourceCollection.createDefaults(uid, userName, gid, groupName, dirMode));
    }

    public void setOverrideAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setOverrideFileAttributes(PlexusIoFileResourceCollection.createDefaults(uid, userName, gid, groupName, fileMode));
        this.setOverrideDirAttributes(PlexusIoFileResourceCollection.createDefaults(uid, userName, gid, groupName, dirMode));
    }

    private static PlexusIoResourceAttributes createDefaults(int uid, String userName, int gid, String groupName, int mode) {
        return new SimpleResourceAttributes(uid, userName, gid, groupName, mode >= 0 ? mode : -1);
    }

    private void addResources(List<PlexusIoResource> result, String[] resources, Map<String, PlexusIoResourceAttributes> attributesByPath) throws IOException {
        File dir = this.getBaseDir();
        for (String name : resources) {
            PlexusIoFileResource resource;
            String sourceDir = name.replace('\\', '/');
            File f = new File(dir, sourceDir);
            PlexusIoResourceAttributes attrs = attributesByPath.get(name.length() > 0 ? name : ".");
            if (attrs == null) {
                attrs = attributesByPath.get(f.getAbsolutePath());
            }
            if (attrs == null) {
                attrs = SimpleResourceAttributes.lastResortDummyAttributesForBrokenOS();
            }
            if (!this.isSelected(resource = PlexusIoFileResource.fileOnDisk(f, name, attrs = f.isDirectory() ? PlexusIoResourceAttributeUtils.mergeAttributes(this.getOverrideDirAttributes(), attrs, this.getDefaultDirAttributes()) : PlexusIoResourceAttributeUtils.mergeAttributes(this.getOverrideFileAttributes(), attrs, this.getDefaultFileAttributes())))) continue;
            result.add(resource);
        }
    }

    private void addResourcesJava7(List<PlexusIoResource> result, String[] resources) throws IOException {
        File dir = this.getBaseDir();
        HashMap<Integer, String> cache1 = new HashMap<Integer, String>();
        HashMap<Integer, String> cache2 = new HashMap<Integer, String>();
        for (String name : resources) {
            String sourceDir = name.replace('\\', '/');
            File f = new File(dir, sourceDir);
            PlexusIoResourceAttributes attrs = new Java7FileAttributes(f, cache1, cache2);
            attrs = f.isDirectory() ? PlexusIoResourceAttributeUtils.mergeAttributes(this.getOverrideDirAttributes(), attrs, this.getDefaultDirAttributes()) : PlexusIoResourceAttributeUtils.mergeAttributes(this.getOverrideFileAttributes(), attrs, this.getDefaultFileAttributes());
            PlexusIoFileResource resource = PlexusIoFileResource.fileOnDisk(f, name, attrs);
            if (!this.isSelected(resource)) continue;
            result.add(resource);
        }
    }

    @Override
    public Iterator<PlexusIoResource> getResources() throws IOException {
        String[] exc;
        DirectoryScanner ds = new DirectoryScanner();
        File dir = this.getBaseDir();
        ds.setBasedir(dir);
        String[] inc = this.getIncludes();
        if (inc != null && inc.length > 0) {
            ds.setIncludes(inc);
        }
        if ((exc = this.getExcludes()) != null && exc.length > 0) {
            ds.setExcludes(exc);
        }
        if (this.isUsingDefaultExcludes()) {
            ds.addDefaultExcludes();
        }
        ds.setCaseSensitive(this.isCaseSensitive());
        ds.setFollowSymlinks(this.isFollowingSymLinks());
        ds.scan();
        if (Java7Reflector.isAtLeastJava7()) {
            ArrayList<PlexusIoResource> result = new ArrayList<PlexusIoResource>();
            if (this.isIncludingEmptyDirectories()) {
                String[] dirs = ds.getIncludedDirectories();
                this.addResourcesJava7(result, dirs);
            }
            String[] files = ds.getIncludedFiles();
            this.addResourcesJava7(result, files);
            return result.iterator();
        }
        Map<String, PlexusIoResourceAttributes> attributesByPath = PlexusIoResourceAttributeUtils.getFileAttributesByPath(this.getBaseDir());
        ArrayList<PlexusIoResource> result = new ArrayList<PlexusIoResource>();
        if (this.isIncludingEmptyDirectories()) {
            String[] dirs = ds.getIncludedDirectories();
            this.addResources(result, dirs, attributesByPath);
        }
        String[] files = ds.getIncludedFiles();
        this.addResources(result, files, attributesByPath);
        return result.iterator();
    }
}

