/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoURLResource;

public class PlexusIoZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection {
    public static final String ROLE_HINT = "zipFile";
    public static final String JAR_ROLE_HINT = "jarFile";

    protected Iterator getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The zip file has not been set.");
        }
        final URL url = new URL("jar:" + f.toURI().toURL() + "!/");
        ZipFile zipFile = new ZipFile(f);
        final Enumeration<? extends ZipEntry> en = zipFile.entries();
        return new Iterator(){

            public boolean hasNext() {
                return en.hasMoreElements();
            }

            public Object next() {
                ZipEntry entry = (ZipEntry)en.nextElement();
                PlexusIoURLResource res = new PlexusIoURLResource(this, entry){
                    private final /* synthetic */ ZipEntry val$entry;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$entry = val$entry;
                    }

                    public URL getURL() throws IOException {
                        return new URL(1.access$000(this.this$1), this.val$entry.getName());
                    }
                };
                boolean dir = entry.isDirectory();
                res.setName(entry.getName());
                res.setDirectory(dir);
                res.setExisting(true);
                res.setFile(!dir);
                long l = entry.getTime();
                res.setLastModified(l == -1L ? 0L : l);
                res.setSize(dir ? -1L : entry.getSize());
                return res;
            }

            public void remove() {
                throw new UnsupportedOperationException("Removing isn't implemented.");
            }

            static /* synthetic */ URL access$000(1 x0) {
                return x0.url;
            }
        };
    }
}

